/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.messaging.simp.handler.MutableUserQueueSuffixResolver;

public class SimpleUserQueueSuffixResolver
implements MutableUserQueueSuffixResolver {
    private final ConcurrentMap<String, Map<String, String>> cache = new ConcurrentHashMap<String, Map<String, String>>();

    @Override
    public void addQueueSuffix(String user, String sessionId, String suffix) {
        Map prevSuffixes;
        Map<String, String> suffixes = (ConcurrentHashMap<String, String>)this.cache.get(user);
        if (suffixes == null && (prevSuffixes = (Map)this.cache.putIfAbsent(user, suffixes = new ConcurrentHashMap<String, String>())) != null) {
            suffixes = prevSuffixes;
        }
        suffixes.put(sessionId, suffix);
    }

    @Override
    public void removeQueueSuffix(String user, String sessionId) {
        Map suffixes = (Map)this.cache.get(user);
        if (suffixes != null && suffixes.remove(sessionId) != null) {
            this.cache.remove(user, Collections.emptyMap());
        }
    }

    @Override
    public Set<String> getUserQueueSuffixes(String user) {
        Map suffixes = (Map)this.cache.get(user);
        return suffixes != null ? new HashSet(suffixes.values()) : Collections.emptySet();
    }

    @Override
    public String getUserQueueSuffix(String user, String sessionId) {
        Map suffixes = (Map)this.cache.get(user);
        if (suffixes != null) {
            return (String)suffixes.get(sessionId);
        }
        return null;
    }
}

