/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.handler;

import java.util.Collection;
import java.util.List;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.handler.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.handler.DefaultSubscriptionRegistry;
import org.springframework.messaging.simp.handler.SubscriptionRegistry;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class SimpleBrokerMessageHandler
extends AbstractBrokerMessageHandler {
    private final MessageChannel messageChannel;
    private SubscriptionRegistry subscriptionRegistry = new DefaultSubscriptionRegistry();

    public SimpleBrokerMessageHandler(MessageChannel messageChannel, Collection<String> destinationPrefixes) {
        super(destinationPrefixes);
        Assert.notNull((Object)messageChannel, (String)"messageChannel is required");
        this.messageChannel = messageChannel;
    }

    public MessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public void setSubscriptionRegistry(SubscriptionRegistry subscriptionRegistry) {
        Assert.notNull((Object)subscriptionRegistry, (String)"subscriptionRegistry is required");
        this.subscriptionRegistry = subscriptionRegistry;
    }

    public SubscriptionRegistry getSubscriptionRegistry() {
        return this.subscriptionRegistry;
    }

    @Override
    public void startInternal() {
        this.publishBrokerAvailableEvent();
    }

    @Override
    public void stopInternal() {
        this.publishBrokerUnavailableEvent();
    }

    @Override
    protected void handleMessageInternal(Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        SimpMessageType messageType = headers.getMessageType();
        String destination = headers.getDestination();
        if (!this.checkDestinationPrefix(destination)) {
            return;
        }
        if (SimpMessageType.SUBSCRIBE.equals((Object)messageType)) {
            this.preProcessMessage(message);
            this.subscriptionRegistry.registerSubscription(message);
        } else if (SimpMessageType.UNSUBSCRIBE.equals((Object)messageType)) {
            this.preProcessMessage(message);
            this.subscriptionRegistry.unregisterSubscription(message);
        } else if (SimpMessageType.MESSAGE.equals((Object)messageType)) {
            this.preProcessMessage(message);
            this.sendMessageToSubscribers(headers.getDestination(), message);
        } else if (SimpMessageType.DISCONNECT.equals((Object)messageType)) {
            this.preProcessMessage(message);
            String sessionId = SimpMessageHeaderAccessor.wrap(message).getSessionId();
            this.subscriptionRegistry.unregisterAllSubscriptions(sessionId);
        }
    }

    private void preProcessMessage(Message<?> message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Processing " + message));
        }
    }

    protected void sendMessageToSubscribers(String destination, Message<?> message) {
        MultiValueMap<String, String> subscriptions = this.subscriptionRegistry.findSubscriptions(message);
        for (String sessionId : subscriptions.keySet()) {
            for (String subscriptionId : (List)subscriptions.get((Object)sessionId)) {
                SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
                headers.setSessionId(sessionId);
                headers.setSubscriptionId(subscriptionId);
                Object payload = message.getPayload();
                Message<?> clientMessage = MessageBuilder.withPayloadAndHeaders(payload, headers).build();
                try {
                    this.messageChannel.send(clientMessage);
                }
                catch (Throwable ex) {
                    this.logger.error((Object)("Failed to send message to destination=" + destination + ", sessionId=" + sessionId + ", subscriptionId=" + subscriptionId), ex);
                }
            }
        }
    }
}

