/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.handler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.handler.AbstractSubscriptionRegistry;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.util.Assert;

public class DefaultSubscriptionRegistry
extends AbstractSubscriptionRegistry {
    private final DestinationCache destinationCache = new DestinationCache();
    private final SessionSubscriptionRegistry subscriptionRegistry = new SessionSubscriptionRegistry();
    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public void setPathMatcher(AntPathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public AntPathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    protected void addSubscriptionInternal(String sessionId, String subsId, String destination, Message<?> message) {
        SessionSubscriptionInfo info = this.subscriptionRegistry.addSubscription(sessionId, subsId, destination);
        if (!this.pathMatcher.isPattern(destination)) {
            this.destinationCache.mapToDestination(destination, info);
        }
    }

    @Override
    protected void removeSubscriptionInternal(String sessionId, String subscriptionId, Message<?> message) {
        String destination;
        SessionSubscriptionInfo info = this.subscriptionRegistry.getSubscriptions(sessionId);
        if (info != null && info.getSubscriptions(destination = info.removeSubscription(subscriptionId)) == null) {
            this.destinationCache.unmapFromDestination(destination, info);
        }
    }

    @Override
    public void unregisterAllSubscriptions(String sessionId) {
        SessionSubscriptionInfo info = this.subscriptionRegistry.removeSubscriptions(sessionId);
        if (info != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unregistering subscriptions for sessionId=" + sessionId));
            }
            this.destinationCache.removeSessionSubscriptions(info);
        }
    }

    @Override
    protected MultiValueMap<String, String> findSubscriptionsInternal(String destination, Message<?> message) {
        LinkedMultiValueMap result = this.destinationCache.getSubscriptions(destination);
        if (result.isEmpty()) {
            result = new LinkedMultiValueMap();
            for (SessionSubscriptionInfo info : this.subscriptionRegistry.getAllSubscriptions()) {
                for (String destinationPattern : info.getDestinations()) {
                    if (!this.pathMatcher.match(destinationPattern, destination)) continue;
                    for (String subscriptionId : info.getSubscriptions(destinationPattern)) {
                        result.add((Object)info.sessionId, (Object)subscriptionId);
                    }
                }
            }
        }
        return result;
    }

    public String toString() {
        return "[destinationCache=" + this.destinationCache + ", subscriptionRegistry=" + this.subscriptionRegistry + "]";
    }

    private static class SessionSubscriptionInfo {
        private final String sessionId;
        private final Map<String, Set<String>> subscriptions = new ConcurrentHashMap<String, Set<String>>(4);
        private final Object monitor = new Object();

        public SessionSubscriptionInfo(String sessionId) {
            Assert.notNull((Object)sessionId, (String)"sessionId is required");
            this.sessionId = sessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Set<String> getDestinations() {
            return this.subscriptions.keySet();
        }

        public Set<String> getSubscriptions(String destination) {
            return this.subscriptions.get(destination);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubscription(String destination, String subscriptionId) {
            Set<String> subs = this.subscriptions.get(destination);
            if (subs == null) {
                Object object = this.monitor;
                synchronized (object) {
                    subs = this.subscriptions.get(destination);
                    if (subs == null) {
                        subs = new HashSet<String>(4);
                        this.subscriptions.put(destination, subs);
                    }
                }
            }
            subs.add(subscriptionId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String removeSubscription(String subscriptionId) {
            for (String destination : this.subscriptions.keySet()) {
                Set<String> subscriptionIds = this.subscriptions.get(destination);
                if (!subscriptionIds.remove(subscriptionId)) continue;
                Object object = this.monitor;
                synchronized (object) {
                    if (subscriptionIds.isEmpty()) {
                        this.subscriptions.remove(destination);
                    }
                }
                return destination;
            }
            return null;
        }

        public String toString() {
            return "[sessionId=" + this.sessionId + ", subscriptions=" + this.subscriptions + "]";
        }
    }

    private static class SessionSubscriptionRegistry {
        private final ConcurrentMap<String, SessionSubscriptionInfo> sessions = new ConcurrentHashMap<String, SessionSubscriptionInfo>();

        private SessionSubscriptionRegistry() {
        }

        public SessionSubscriptionInfo getSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.get(sessionId);
        }

        public Collection<SessionSubscriptionInfo> getAllSubscriptions() {
            return this.sessions.values();
        }

        public SessionSubscriptionInfo addSubscription(String sessionId, String subscriptionId, String destination) {
            SessionSubscriptionInfo value;
            SessionSubscriptionInfo info = (SessionSubscriptionInfo)this.sessions.get(sessionId);
            if (info == null && (value = this.sessions.putIfAbsent(sessionId, info = new SessionSubscriptionInfo(sessionId))) != null) {
                info = value;
            }
            info.addSubscription(destination, subscriptionId);
            return info;
        }

        public SessionSubscriptionInfo removeSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.remove(sessionId);
        }

        public String toString() {
            return "[sessions=" + this.sessions + "]";
        }
    }

    private static class DestinationCache {
        private final Map<String, Set<SessionSubscriptionInfo>> subscriptionsByDestination = new ConcurrentHashMap<String, Set<SessionSubscriptionInfo>>();
        private final Object monitor = new Object();

        private DestinationCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mapToDestination(String destination, SessionSubscriptionInfo info) {
            Object object = this.monitor;
            synchronized (object) {
                Set<SessionSubscriptionInfo> registrations = this.subscriptionsByDestination.get(destination);
                if (registrations == null) {
                    registrations = new CopyOnWriteArraySet<SessionSubscriptionInfo>();
                    this.subscriptionsByDestination.put(destination, registrations);
                }
                registrations.add(info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unmapFromDestination(String destination, SessionSubscriptionInfo info) {
            Object object = this.monitor;
            synchronized (object) {
                Set<SessionSubscriptionInfo> infos = this.subscriptionsByDestination.get(destination);
                if (infos != null) {
                    infos.remove(info);
                    if (infos.isEmpty()) {
                        this.subscriptionsByDestination.remove(destination);
                    }
                }
            }
        }

        public void removeSessionSubscriptions(SessionSubscriptionInfo info) {
            for (String destination : info.getDestinations()) {
                this.unmapFromDestination(destination, info);
            }
        }

        public MultiValueMap<String, String> getSubscriptions(String destination) {
            LinkedMultiValueMap result = new LinkedMultiValueMap();
            Set<SessionSubscriptionInfo> infos = this.subscriptionsByDestination.get(destination);
            if (infos != null) {
                for (SessionSubscriptionInfo info : infos) {
                    Set<String> subscriptions = info.getSubscriptions(destination);
                    if (subscriptions == null) continue;
                    for (String subscription : subscriptions) {
                        result.add((Object)info.getSessionId(), (Object)subscription);
                    }
                }
            }
            return result;
        }

        public String toString() {
            return "[subscriptionsByDestination=" + this.subscriptionsByDestination + "]";
        }
    }
}

