/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.support.ExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.MessageBodyMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.method.HandlerMethod;
import org.springframework.messaging.handler.method.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.method.HandlerMethodArgumentResolverComposite;
import org.springframework.messaging.handler.method.HandlerMethodReturnValueHandler;
import org.springframework.messaging.handler.method.HandlerMethodReturnValueHandlerComposite;
import org.springframework.messaging.handler.method.HandlerMethodSelector;
import org.springframework.messaging.handler.method.InvocableHandlerMethod;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.SubscribeEvent;
import org.springframework.messaging.simp.annotation.UnsubscribeEvent;
import org.springframework.messaging.simp.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.messaging.simp.annotation.support.ReplyToMethodReturnValueHandler;
import org.springframework.messaging.simp.annotation.support.SubscriptionMethodReturnValueHandler;
import org.springframework.messaging.support.converter.MessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class AnnotationMethodMessageHandler
implements MessageHandler,
ApplicationContextAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(AnnotationMethodMessageHandler.class);
    private final SimpMessageSendingOperations brokerTemplate;
    private final SimpMessageSendingOperations webSocketReplyTemplate;
    private Collection<String> destinationPrefixes;
    private MessageConverter<?> messageConverter;
    private ApplicationContext applicationContext;
    private Map<MappingInfo, HandlerMethod> messageMethods = new HashMap<MappingInfo, HandlerMethod>();
    private Map<MappingInfo, HandlerMethod> subscribeMethods = new HashMap<MappingInfo, HandlerMethod>();
    private Map<MappingInfo, HandlerMethod> unsubscribeMethods = new HashMap<MappingInfo, HandlerMethod>();
    private final Map<Class<?>, ExceptionHandlerMethodResolver> exceptionHandlerCache = new ConcurrentHashMap(64);
    private List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
    private List<HandlerMethodReturnValueHandler> customReturnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
    private HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private HandlerMethodReturnValueHandlerComposite returnValueHandlers = new HandlerMethodReturnValueHandlerComposite();

    public AnnotationMethodMessageHandler(SimpMessageSendingOperations brokerTemplate, MessageChannel webSocketReplyChannel) {
        Assert.notNull((Object)brokerTemplate, (String)"brokerTemplate is required");
        Assert.notNull((Object)webSocketReplyChannel, (String)"webSocketReplyChannel is required");
        this.brokerTemplate = brokerTemplate;
        this.webSocketReplyTemplate = new SimpMessagingTemplate(webSocketReplyChannel);
    }

    public void setDestinationPrefixes(Collection<String> destinationPrefixes) {
        this.destinationPrefixes = destinationPrefixes;
    }

    public Collection<String> getDestinationPrefixes() {
        return this.destinationPrefixes;
    }

    public void setMessageConverter(MessageConverter<?> converter) {
        this.messageConverter = converter;
        if (converter != null) {
            ((AbstractMessageSendingTemplate)((Object)this.webSocketReplyTemplate)).setMessageConverter(converter);
        }
    }

    public void setCustomArgumentResolvers(List<HandlerMethodArgumentResolver> customArgumentResolvers) {
        Assert.notNull(customArgumentResolvers, (String)"The 'customArgumentResolvers' cannot be null.");
        this.customArgumentResolvers = customArgumentResolvers;
    }

    public void setCustomReturnValueHandlers(List<HandlerMethodReturnValueHandler> customReturnValueHandlers) {
        Assert.notNull(customReturnValueHandlers, (String)"The 'customReturnValueHandlers' cannot be null.");
        this.customReturnValueHandlers = customReturnValueHandlers;
    }

    public MessageConverter<?> getMessageConverter() {
        return this.messageConverter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.initHandlerMethods();
        this.argumentResolvers.addResolver(new PrincipalMethodArgumentResolver());
        this.argumentResolvers.addResolver(new MessageMethodArgumentResolver());
        this.argumentResolvers.addResolvers(this.customArgumentResolvers);
        this.argumentResolvers.addResolver(new MessageBodyMethodArgumentResolver(this.messageConverter));
        this.returnValueHandlers.addHandler(new ReplyToMethodReturnValueHandler(this.brokerTemplate));
        this.returnValueHandlers.addHandler(new SubscriptionMethodReturnValueHandler(this.webSocketReplyTemplate));
        this.returnValueHandlers.addHandlers(this.customReturnValueHandlers);
    }

    protected void initHandlerMethods() {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForType(Object.class)) {
            if (!this.isHandler(this.applicationContext.getType(beanName))) continue;
            this.detectHandlerMethods(beanName);
        }
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, Controller.class) != null;
    }

    protected void detectHandlerMethods(Object handler) {
        Class handlerType = handler instanceof String ? this.applicationContext.getType((String)handler) : handler.getClass();
        Class userType = ClassUtils.getUserClass((Class)handlerType);
        this.initHandlerMethods(handler, userType, MessageMapping.class, new MessageMappingInfoCreator(), this.messageMethods);
        this.initHandlerMethods(handler, userType, SubscribeEvent.class, new SubscribeMappingInfoCreator(), this.subscribeMethods);
        this.initHandlerMethods(handler, userType, UnsubscribeEvent.class, new UnsubscribeMappingInfoCreator(), this.unsubscribeMethods);
    }

    private <A extends Annotation> void initHandlerMethods(Object handler, Class<?> handlerType, final Class<A> annotationType, MappingInfoCreator<A> mappingInfoCreator, Map<MappingInfo, HandlerMethod> handlerMethods) {
        Set<Method> messageMethods = HandlerMethodSelector.selectMethods(handlerType, new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return AnnotationUtils.findAnnotation((Method)method, (Class)annotationType) != null;
            }
        });
        for (Method method : messageMethods) {
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationType);
            HandlerMethod hm = this.createHandlerMethod(handler, method);
            handlerMethods.put(mappingInfoCreator.create(annotation), hm);
        }
    }

    protected HandlerMethod createHandlerMethod(Object handler, Method method) {
        HandlerMethod handlerMethod;
        if (handler instanceof String) {
            String beanName = (String)handler;
            handlerMethod = new HandlerMethod(beanName, (BeanFactory)this.applicationContext, method);
        } else {
            handlerMethod = new HandlerMethod(handler, method);
        }
        return handlerMethod;
    }

    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        SimpMessageType messageType = headers.getMessageType();
        if (SimpMessageType.MESSAGE.equals((Object)messageType)) {
            this.handleMessageInternal(message, this.messageMethods);
        } else if (SimpMessageType.SUBSCRIBE.equals((Object)messageType)) {
            this.handleMessageInternal(message, this.subscribeMethods);
        } else if (SimpMessageType.UNSUBSCRIBE.equals((Object)messageType)) {
            this.handleMessageInternal(message, this.unsubscribeMethods);
        }
    }

    private void handleMessageInternal(Message<?> message, Map<MappingInfo, HandlerMethod> handlerMethods) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        String destination = headers.getDestination();
        if (!this.checkDestinationPrefix(destination)) {
            return;
        }
        HandlerMethod match = this.getHandlerMethod(destination, handlerMethods);
        if (match == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Processing message: " + message));
        }
        HandlerMethod handlerMethod = match.createWithResolvedBean();
        InvocableHandlerMethod invocableHandlerMethod = new InvocableHandlerMethod(handlerMethod);
        invocableHandlerMethod.setMessageMethodArgumentResolvers(this.argumentResolvers);
        try {
            Object returnValue = invocableHandlerMethod.invoke(message, new Object[0]);
            MethodParameter returnType = handlerMethod.getReturnType();
            if (Void.TYPE.equals(returnType.getParameterType())) {
                return;
            }
            this.returnValueHandlers.handleReturnValue(returnValue, returnType, message);
        }
        catch (Exception ex) {
            this.invokeExceptionHandler(message, handlerMethod, ex);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private boolean checkDestinationPrefix(String destination) {
        if (destination == null || CollectionUtils.isEmpty(this.destinationPrefixes)) {
            return true;
        }
        for (String prefix : this.destinationPrefixes) {
            if (!destination.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void invokeExceptionHandler(Message<?> message, HandlerMethod handlerMethod, Exception ex) {
        Method method;
        Class<?> beanType = handlerMethod.getBeanType();
        ExceptionHandlerMethodResolver resolver = this.exceptionHandlerCache.get(beanType);
        if (resolver == null) {
            resolver = new ExceptionHandlerMethodResolver(beanType);
            this.exceptionHandlerCache.put(beanType, resolver);
        }
        if ((method = resolver.resolveMethod(ex)) == null) {
            logger.error((Object)"Unhandled exception", (Throwable)ex);
            return;
        }
        InvocableHandlerMethod exceptionHandlerMethod = new InvocableHandlerMethod(handlerMethod.getBean(), method);
        exceptionHandlerMethod.setMessageMethodArgumentResolvers(this.argumentResolvers);
        try {
            Object returnValue = exceptionHandlerMethod.invoke(message, ex);
            MethodParameter returnType = exceptionHandlerMethod.getReturnType();
            if (Void.TYPE.equals(returnType.getParameterType())) {
                return;
            }
            this.returnValueHandlers.handleReturnValue(returnValue, returnType, message);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while handling exception", t);
            return;
        }
    }

    protected HandlerMethod getHandlerMethod(String destination, Map<MappingInfo, HandlerMethod> handlerMethods) {
        for (MappingInfo key : handlerMethods.keySet()) {
            for (String mappingDestination : key.getDestinations()) {
                if (!destination.equals(mappingDestination)) continue;
                return handlerMethods.get(key);
            }
        }
        return null;
    }

    private static class UnsubscribeMappingInfoCreator
    implements MappingInfoCreator<UnsubscribeEvent> {
        private UnsubscribeMappingInfoCreator() {
        }

        @Override
        public MappingInfo create(UnsubscribeEvent annotation) {
            return new MappingInfo(Arrays.asList(annotation.value()));
        }
    }

    private static class SubscribeMappingInfoCreator
    implements MappingInfoCreator<SubscribeEvent> {
        private SubscribeMappingInfoCreator() {
        }

        @Override
        public MappingInfo create(SubscribeEvent annotation) {
            return new MappingInfo(Arrays.asList(annotation.value()));
        }
    }

    private static class MessageMappingInfoCreator
    implements MappingInfoCreator<MessageMapping> {
        private MessageMappingInfoCreator() {
        }

        @Override
        public MappingInfo create(MessageMapping annotation) {
            return new MappingInfo(Arrays.asList(annotation.value()));
        }
    }

    private static interface MappingInfoCreator<A extends Annotation> {
        public MappingInfo create(A var1);
    }

    private static class MappingInfo {
        private final List<String> destinations;

        public MappingInfo(List<String> destinations) {
            this.destinations = destinations;
        }

        public List<String> getDestinations() {
            return this.destinations;
        }

        public String toString() {
            return "MappingInfo [destinations=" + this.destinations + "]";
        }
    }
}

