/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.handler;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.simp.BrokerAvailabilityEvent;
import org.springframework.util.CollectionUtils;

public abstract class AbstractBrokerMessageHandler
implements MessageHandler,
SmartLifecycle,
ApplicationEventPublisherAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Collection<String> destinationPrefixes;
    private ApplicationEventPublisher eventPublisher;
    private AtomicBoolean brokerAvailable = new AtomicBoolean(false);
    private Object lifecycleMonitor = new Object();
    private volatile boolean running = false;

    public AbstractBrokerMessageHandler(Collection<String> destinationPrefixes) {
        this.destinationPrefixes = destinationPrefixes != null ? destinationPrefixes : Collections.emptyList();
    }

    public Collection<String> getDestinationPrefixes() {
        return this.destinationPrefixes;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.eventPublisher = publisher;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.eventPublisher;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Starting " + this.getClass().getSimpleName()));
            }
            this.startInternal();
            this.running = true;
        }
    }

    protected void startInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Stopping " + this.getClass().getSimpleName()));
            }
            this.stopInternal();
            this.running = false;
        }
    }

    protected void stopInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    @Override
    public final void handleMessage(Message<?> message) {
        if (!this.running) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("STOMP broker relay not running. Ignoring message id=" + message.getHeaders().getId()));
            }
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Processing message: " + message));
        }
        this.handleMessageInternal(message);
    }

    protected abstract void handleMessageInternal(Message<?> var1);

    protected boolean checkDestinationPrefix(String destination) {
        if (destination == null || CollectionUtils.isEmpty(this.destinationPrefixes)) {
            return true;
        }
        for (String prefix : this.destinationPrefixes) {
            if (!destination.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected void publishBrokerAvailableEvent() {
        if (this.eventPublisher != null && this.brokerAvailable.compareAndSet(false, true)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Publishing BrokerAvailabilityEvent (available)");
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new BrokerAvailabilityEvent(true, this));
        }
    }

    protected void publishBrokerUnavailableEvent() {
        if (this.eventPublisher != null && this.brokerAvailable.compareAndSet(true, false)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Publishing BrokerAvailabilityEvent (unavailable)");
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new BrokerAvailabilityEvent(false, this));
        }
    }
}

