/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.concurrent.Executor;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.handler.websocket.SubProtocolWebSocketHandler;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.config.MessageBrokerConfigurer;
import org.springframework.messaging.simp.config.StompEndpointRegistry;
import org.springframework.messaging.simp.handler.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.handler.AnnotationMethodMessageHandler;
import org.springframework.messaging.simp.handler.MutableUserQueueSuffixResolver;
import org.springframework.messaging.simp.handler.SimpleUserQueueSuffixResolver;
import org.springframework.messaging.simp.handler.UserDestinationMessageHandler;
import org.springframework.messaging.support.channel.ExecutorSubscribableChannel;
import org.springframework.messaging.support.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.support.converter.MessageConverter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.servlet.HandlerMapping;

public abstract class WebSocketMessageBrokerConfigurationSupport {
    private MessageBrokerConfigurer messageBrokerConfigurer;
    private static final AbstractBrokerMessageHandler noopBroker = new AbstractBrokerMessageHandler(null){

        @Override
        protected void startInternal() {
        }

        @Override
        protected void stopInternal() {
        }

        @Override
        protected void handleMessageInternal(Message<?> message) {
        }
    };

    @Bean
    public HandlerMapping brokerWebSocketHandlerMapping() {
        StompEndpointRegistry registry = new StompEndpointRegistry(this.subProtocolWebSocketHandler(), this.userQueueSuffixResolver(), (TaskScheduler)this.brokerDefaultSockJsTaskScheduler());
        this.registerStompEndpoints(registry);
        return registry.getHandlerMapping();
    }

    @Bean
    public SubProtocolWebSocketHandler subProtocolWebSocketHandler() {
        SubProtocolWebSocketHandler wsHandler = new SubProtocolWebSocketHandler(this.webSocketRequestChannel());
        this.webSocketReplyChannel().subscribe(wsHandler);
        return wsHandler;
    }

    @Bean
    public MutableUserQueueSuffixResolver userQueueSuffixResolver() {
        return new SimpleUserQueueSuffixResolver();
    }

    @Bean
    public ThreadPoolTaskScheduler brokerDefaultSockJsTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("BrokerSockJS-");
        return scheduler;
    }

    protected void registerStompEndpoints(StompEndpointRegistry registry) {
    }

    @Bean
    public SubscribableChannel webSocketRequestChannel() {
        return new ExecutorSubscribableChannel((Executor)this.webSocketChannelExecutor());
    }

    @Bean
    public SubscribableChannel webSocketReplyChannel() {
        return new ExecutorSubscribableChannel((Executor)this.webSocketChannelExecutor());
    }

    @Bean
    public ThreadPoolTaskExecutor webSocketChannelExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("BrokerWebSocketChannel-");
        return executor;
    }

    @Bean
    public AnnotationMethodMessageHandler annotationMethodMessageHandler() {
        AnnotationMethodMessageHandler handler = new AnnotationMethodMessageHandler(this.brokerMessagingTemplate(), this.webSocketReplyChannel());
        handler.setDestinationPrefixes(this.getMessageBrokerConfigurer().getAnnotationMethodDestinationPrefixes());
        handler.setMessageConverter(this.brokerMessageConverter());
        this.webSocketRequestChannel().subscribe(handler);
        return handler;
    }

    @Bean
    public AbstractBrokerMessageHandler simpleBrokerMessageHandler() {
        AbstractBrokerMessageHandler handler = this.getMessageBrokerConfigurer().getSimpleBroker();
        if (handler == null) {
            return noopBroker;
        }
        this.webSocketRequestChannel().subscribe(handler);
        this.brokerMessageChannel().subscribe(handler);
        return handler;
    }

    @Bean
    public AbstractBrokerMessageHandler stompBrokerRelayMessageHandler() {
        AbstractBrokerMessageHandler handler = this.getMessageBrokerConfigurer().getStompBrokerRelay();
        if (handler == null) {
            return noopBroker;
        }
        this.webSocketRequestChannel().subscribe(handler);
        this.brokerMessageChannel().subscribe(handler);
        return handler;
    }

    protected final MessageBrokerConfigurer getMessageBrokerConfigurer() {
        if (this.messageBrokerConfigurer == null) {
            MessageBrokerConfigurer configurer = new MessageBrokerConfigurer(this.webSocketReplyChannel());
            this.configureMessageBroker(configurer);
            this.messageBrokerConfigurer = configurer;
        }
        return this.messageBrokerConfigurer;
    }

    protected void configureMessageBroker(MessageBrokerConfigurer configurer) {
    }

    @Bean
    public UserDestinationMessageHandler userDestinationMessageHandler() {
        UserDestinationMessageHandler handler = new UserDestinationMessageHandler(this.brokerMessagingTemplate(), this.userQueueSuffixResolver());
        this.webSocketRequestChannel().subscribe(handler);
        this.brokerMessageChannel().subscribe(handler);
        return handler;
    }

    @Bean
    public SimpMessageSendingOperations brokerMessagingTemplate() {
        SimpMessagingTemplate template = new SimpMessagingTemplate(this.webSocketRequestChannel());
        template.setMessageConverter(this.brokerMessageConverter());
        return template;
    }

    @Bean
    public SubscribableChannel brokerMessageChannel() {
        return new ExecutorSubscribableChannel();
    }

    @Bean
    public MessageConverter<?> brokerMessageConverter() {
        return new MappingJackson2MessageConverter();
    }
}

