/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.messaging.handler.websocket.SubProtocolWebSocketHandler;
import org.springframework.messaging.simp.config.StompEndpointRegistration;
import org.springframework.messaging.simp.handler.MutableUserQueueSuffixResolver;
import org.springframework.messaging.simp.stomp.StompProtocolHandler;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import reactor.util.Assert;

public class StompEndpointRegistry {
    private final SubProtocolWebSocketHandler wsHandler;
    private final StompProtocolHandler stompHandler;
    private final List<StompEndpointRegistration> registrations = new ArrayList<StompEndpointRegistration>();
    private int order = 1;
    private final TaskScheduler defaultSockJsTaskScheduler;

    public StompEndpointRegistry(SubProtocolWebSocketHandler webSocketHandler, MutableUserQueueSuffixResolver userQueueSuffixResolver, TaskScheduler defaultSockJsTaskScheduler) {
        Assert.notNull((Object)webSocketHandler);
        Assert.notNull((Object)userQueueSuffixResolver);
        this.wsHandler = webSocketHandler;
        this.stompHandler = new StompProtocolHandler();
        this.stompHandler.setUserQueueSuffixResolver(userQueueSuffixResolver);
        this.defaultSockJsTaskScheduler = defaultSockJsTaskScheduler;
    }

    public StompEndpointRegistration addEndpoint(String ... paths) {
        this.wsHandler.addProtocolHandler(this.stompHandler);
        StompEndpointRegistration r = new StompEndpointRegistration(Arrays.asList(paths), this.wsHandler, this.defaultSockJsTaskScheduler);
        this.registrations.add(r);
        return r;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    protected AbstractHandlerMapping getHandlerMapping() {
        LinkedHashMap<String, HttpRequestHandler> urlMap = new LinkedHashMap<String, HttpRequestHandler>();
        for (StompEndpointRegistration registration : this.registrations) {
            MultiValueMap<HttpRequestHandler, String> mappings = registration.getMappings();
            for (HttpRequestHandler httpHandler : mappings.keySet()) {
                for (String pattern : (List)mappings.get((Object)httpHandler)) {
                    urlMap.put(pattern, httpHandler);
                }
            }
        }
        SimpleUrlHandlerMapping hm = new SimpleUrlHandlerMapping();
        hm.setOrder(this.order);
        hm.setUrlMap(urlMap);
        return hm;
    }
}

