/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.messaging.handler.websocket.SubProtocolWebSocketHandler;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.DefaultHandshakeHandler;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.config.SockJsServiceRegistration;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;
import org.springframework.web.socket.sockjs.SockJsHttpRequestHandler;
import org.springframework.web.socket.sockjs.SockJsService;

public class StompEndpointRegistration {
    private final List<String> paths;
    private final SubProtocolWebSocketHandler wsHandler;
    private HandshakeHandler handshakeHandler;
    private StompSockJsServiceRegistration sockJsServiceRegistration;
    private final TaskScheduler defaultSockJsTaskScheduler;

    public StompEndpointRegistration(Collection<String> paths, SubProtocolWebSocketHandler webSocketHandler, TaskScheduler defaultSockJsTaskScheduler) {
        this.paths = new ArrayList<String>(paths);
        this.wsHandler = webSocketHandler;
        this.defaultSockJsTaskScheduler = defaultSockJsTaskScheduler;
    }

    public StompEndpointRegistration setHandshakeHandler(HandshakeHandler handshakeHandler) {
        this.handshakeHandler = handshakeHandler;
        return this;
    }

    public SockJsServiceRegistration withSockJS() {
        this.sockJsServiceRegistration = new StompSockJsServiceRegistration(this.defaultSockJsTaskScheduler);
        return this.sockJsServiceRegistration;
    }

    protected MultiValueMap<HttpRequestHandler, String> getMappings() {
        LinkedMultiValueMap mappings = new LinkedMultiValueMap();
        if (this.sockJsServiceRegistration == null) {
            HandshakeHandler handshakeHandler = this.getOrCreateHandshakeHandler();
            for (String path : this.paths) {
                WebSocketHttpRequestHandler handler = new WebSocketHttpRequestHandler((WebSocketHandler)this.wsHandler, handshakeHandler);
                mappings.add((Object)handler, (Object)path);
            }
        } else {
            SockJsService sockJsService = this.sockJsServiceRegistration.getSockJsService();
            for (String path : this.paths) {
                SockJsHttpRequestHandler httpHandler = new SockJsHttpRequestHandler(sockJsService, (WebSocketHandler)this.wsHandler);
                mappings.add((Object)httpHandler, (Object)(path.endsWith("/") ? path + "**" : path + "/**"));
            }
        }
        return mappings;
    }

    private HandshakeHandler getOrCreateHandshakeHandler() {
        DefaultHandshakeHandler defaultHandshakeHandler;
        HandshakeHandler handler;
        Object object = handler = this.handshakeHandler != null ? this.handshakeHandler : new DefaultHandshakeHandler();
        if (handler instanceof DefaultHandshakeHandler && ObjectUtils.isEmpty((Object[])(defaultHandshakeHandler = (DefaultHandshakeHandler)handler).getSupportedProtocols())) {
            Set<String> protocols = this.wsHandler.getSupportedProtocols();
            defaultHandshakeHandler.setSupportedProtocols(protocols.toArray(new String[protocols.size()]));
        }
        return handler;
    }

    private class StompSockJsServiceRegistration
    extends SockJsServiceRegistration {
        public StompSockJsServiceRegistration(TaskScheduler defaultTaskScheduler) {
            super(defaultTaskScheduler);
        }

        protected SockJsService getSockJsService() {
            return super.getSockJsService(StompEndpointRegistration.this.paths.toArray(new String[StompEndpointRegistration.this.paths.size()]));
        }
    }
}

