/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.config.AbstractBrokerRegistration;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.util.Assert;

public class StompBrokerRelayRegistration
extends AbstractBrokerRegistration {
    private String relayHost = "127.0.0.1";
    private int relayPort = 61613;
    private String applicationLogin = "guest";
    private String applicationPasscode = "guest";

    public StompBrokerRelayRegistration(MessageChannel webSocketReplyChannel, String[] destinationPrefixes) {
        super(webSocketReplyChannel, destinationPrefixes);
    }

    public StompBrokerRelayRegistration setRelayHost(String relayHost) {
        Assert.hasText((String)relayHost, (String)"relayHost must not be empty");
        this.relayHost = relayHost;
        return this;
    }

    protected String getRelayHost() {
        return this.relayHost;
    }

    public StompBrokerRelayRegistration setRelayPort(int relayPort) {
        this.relayPort = relayPort;
        return this;
    }

    protected int getRelayPort() {
        return this.relayPort;
    }

    public StompBrokerRelayRegistration setApplicationLogin(String login) {
        Assert.hasText((String)login, (String)"applicationLogin must not be empty");
        this.applicationLogin = login;
        return this;
    }

    protected String getApplicationLogin() {
        return this.applicationLogin;
    }

    public StompBrokerRelayRegistration setApplicationPasscode(String passcode) {
        Assert.hasText((String)passcode, (String)"applicationPasscode must not be empty");
        this.applicationPasscode = passcode;
        return this;
    }

    protected String getApplicationPasscode() {
        return this.applicationPasscode;
    }

    @Override
    protected StompBrokerRelayMessageHandler getMessageHandler() {
        StompBrokerRelayMessageHandler handler = new StompBrokerRelayMessageHandler(this.getWebSocketReplyChannel(), this.getDestinationPrefixes());
        handler.setRelayHost(this.relayHost);
        handler.setRelayPort(this.relayPort);
        handler.setSystemLogin(this.applicationLogin);
        handler.setSystemPasscode(this.applicationPasscode);
        return handler;
    }
}

