/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.config.SimpleBrokerRegistration;
import org.springframework.messaging.simp.config.StompBrokerRelayRegistration;
import org.springframework.messaging.simp.handler.AbstractBrokerMessageHandler;
import reactor.util.Assert;

public class MessageBrokerConfigurer {
    private final MessageChannel webSocketReplyChannel;
    private SimpleBrokerRegistration simpleBroker;
    private StompBrokerRelayRegistration stompRelay;
    private String[] annotationMethodDestinationPrefixes;

    public MessageBrokerConfigurer(MessageChannel webSocketReplyChannel) {
        Assert.notNull((Object)webSocketReplyChannel);
        this.webSocketReplyChannel = webSocketReplyChannel;
    }

    public SimpleBrokerRegistration enableSimpleBroker(String ... destinationPrefixes) {
        this.simpleBroker = new SimpleBrokerRegistration(this.webSocketReplyChannel, destinationPrefixes);
        return this.simpleBroker;
    }

    public StompBrokerRelayRegistration enableStompBrokerRelay(String ... destinationPrefixes) {
        this.stompRelay = new StompBrokerRelayRegistration(this.webSocketReplyChannel, destinationPrefixes);
        return this.stompRelay;
    }

    public MessageBrokerConfigurer setAnnotationMethodDestinationPrefixes(String ... destinationPrefixes) {
        this.annotationMethodDestinationPrefixes = destinationPrefixes;
        return this;
    }

    protected AbstractBrokerMessageHandler getSimpleBroker() {
        this.initSimpleBrokerIfNecessary();
        return this.simpleBroker != null ? this.simpleBroker.getMessageHandler() : null;
    }

    protected void initSimpleBrokerIfNecessary() {
        if (this.simpleBroker == null && this.stompRelay == null) {
            this.simpleBroker = new SimpleBrokerRegistration(this.webSocketReplyChannel, null);
        }
    }

    protected AbstractBrokerMessageHandler getStompBrokerRelay() {
        return this.stompRelay != null ? this.stompRelay.getMessageHandler() : null;
    }

    protected Collection<String> getAnnotationMethodDestinationPrefixes() {
        return this.annotationMethodDestinationPrefixes != null ? Arrays.asList(this.annotationMethodDestinationPrefixes) : null;
    }
}

