/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerConfigurer;
import org.springframework.messaging.simp.config.StompEndpointRegistry;
import org.springframework.messaging.simp.config.WebSocketMessageBrokerConfigurationSupport;
import org.springframework.messaging.simp.config.WebSocketMessageBrokerConfigurer;
import org.springframework.util.CollectionUtils;

@Configuration
public class DelegatingWebSocketMessageBrokerConfiguration
extends WebSocketMessageBrokerConfigurationSupport {
    private List<WebSocketMessageBrokerConfigurer> configurers = new ArrayList<WebSocketMessageBrokerConfigurer>();

    @Autowired(required=false)
    public void setConfigurers(List<WebSocketMessageBrokerConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        this.configurers.addAll(configurers);
    }

    @Override
    protected void registerStompEndpoints(StompEndpointRegistry registry) {
        for (WebSocketMessageBrokerConfigurer c : this.configurers) {
            c.registerStompEndpoints(registry);
        }
    }

    @Override
    protected void configureMessageBroker(MessageBrokerConfigurer configurer) {
        for (WebSocketMessageBrokerConfigurer c : this.configurers) {
            c.configureMessageBroker(configurer);
        }
    }
}

