/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.handler.AbstractBrokerMessageHandler;
import reactor.util.Assert;

public abstract class AbstractBrokerRegistration {
    private final MessageChannel webSocketReplyChannel;
    private final String[] destinationPrefixes;

    public AbstractBrokerRegistration(MessageChannel webSocketReplyChannel, String[] destinationPrefixes) {
        Assert.notNull((Object)webSocketReplyChannel, (String)"");
        this.webSocketReplyChannel = webSocketReplyChannel;
        this.destinationPrefixes = destinationPrefixes;
    }

    protected MessageChannel getWebSocketReplyChannel() {
        return this.webSocketReplyChannel;
    }

    protected Collection<String> getDestinationPrefixes() {
        return this.destinationPrefixes != null ? Arrays.asList(this.destinationPrefixes) : Collections.emptyList();
    }

    protected abstract AbstractBrokerMessageHandler getMessageHandler();
}

