/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.annotation.support;

import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.handler.annotation.ReplyTo;
import org.springframework.messaging.handler.method.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.annotation.ReplyToUser;
import org.springframework.messaging.simp.annotation.support.MissingSessionUserException;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class ReplyToMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final SimpMessageSendingOperations messagingTemplate;

    public ReplyToMethodReturnValueHandler(SimpMessageSendingOperations messagingTemplate) {
        Assert.notNull((Object)messagingTemplate, (String)"messagingTemplate is required");
        this.messagingTemplate = messagingTemplate;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return returnType.getMethodAnnotation(ReplyTo.class) != null || returnType.getMethodAnnotation(ReplyToUser.class) != null;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> inputMessage) throws Exception {
        ReplyToUser replyToUser;
        if (returnValue == null) {
            return;
        }
        SimpMessageHeaderAccessor inputHeaders = SimpMessageHeaderAccessor.wrap(inputMessage);
        String sessionId = inputHeaders.getSessionId();
        SessionHeaderPostProcessor postProcessor = new SessionHeaderPostProcessor(sessionId);
        ReplyTo replyTo = (ReplyTo)returnType.getMethodAnnotation(ReplyTo.class);
        if (replyTo != null) {
            for (String destination : replyTo.value()) {
                this.messagingTemplate.convertAndSend(destination, returnValue, postProcessor);
            }
        }
        if ((replyToUser = (ReplyToUser)returnType.getMethodAnnotation(ReplyToUser.class)) != null) {
            if (inputHeaders.getUser() == null) {
                throw new MissingSessionUserException(inputMessage);
            }
            String user = inputHeaders.getUser().getName();
            for (String destination : replyToUser.value()) {
                this.messagingTemplate.convertAndSendToUser(user, destination, returnValue, postProcessor);
            }
        }
    }

    private final class SessionHeaderPostProcessor
    implements MessagePostProcessor {
        private final String sessionId;

        public SessionHeaderPostProcessor(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public Message<?> postProcessMessage(Message<?> message) {
            SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
            headers.setSessionId(this.sessionId);
            return MessageBuilder.withPayloadAndHeaders(message.getPayload(), headers).build();
        }
    }
}

