/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp;

import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class SimpMessagingTemplate
extends AbstractMessageSendingTemplate<String>
implements SimpMessageSendingOperations {
    private final MessageChannel messageChannel;
    private String userDestinationPrefix = "/user/";
    private volatile long sendTimeout = -1L;

    public SimpMessagingTemplate(MessageChannel messageChannel) {
        Assert.notNull((Object)messageChannel, (String)"messageChannel is required");
        this.messageChannel = messageChannel;
    }

    public void setUserDestinationPrefix(String prefix) {
        Assert.notNull((Object)prefix, (String)"userDestinationPrefix is required");
        this.userDestinationPrefix = prefix;
    }

    public String getUserDestinationPrefix() {
        return this.userDestinationPrefix;
    }

    public MessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    @Override
    public <P> void send(Message<P> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        String destination = headers.getDestination();
        destination = destination != null ? destination : (String)this.getRequiredDefaultDestination();
        this.doSend((String)this.getRequiredDefaultDestination(), message);
    }

    @Override
    protected void doSend(String destination, Message<?> message) {
        boolean sent;
        Assert.notNull((Object)destination, (String)"destination is required");
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        headers.setDestination(destination);
        headers.setMessageTypeIfNotSet(SimpMessageType.MESSAGE);
        message = MessageBuilder.withPayloadAndHeaders(message.getPayload(), headers).build();
        long timeout = this.sendTimeout;
        boolean bl = sent = timeout >= 0L ? this.messageChannel.send(message, timeout) : this.messageChannel.send(message);
        if (!sent) {
            throw new MessageDeliveryException(message, "failed to send message to destination '" + destination + "' within timeout: " + timeout);
        }
    }

    @Override
    public <T> void convertAndSendToUser(String user, String destination, T message) throws MessagingException {
        this.convertAndSendToUser(user, destination, message, null);
    }

    @Override
    public <T> void convertAndSendToUser(String user, String destination, T message, MessagePostProcessor postProcessor) throws MessagingException {
        Assert.notNull((Object)user, (String)"user is required");
        this.convertAndSend(this.userDestinationPrefix + user + destination, message, postProcessor);
    }
}

