/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.Assert;

public class SimpMessageHeaderAccessor
extends NativeMessageHeaderAccessor {
    public static final String DESTINATION_HEADER = "destination";
    public static final String MESSAGE_TYPE_HEADER = "messageType";
    public static final String SESSION_ID_HEADER = "sessionId";
    public static final String SUBSCRIPTION_ID_HEADER = "subscriptionId";
    public static final String USER_HEADER = "user";

    protected SimpMessageHeaderAccessor(SimpMessageType messageType, Map<String, List<String>> externalSourceHeaders) {
        super(externalSourceHeaders);
        Assert.notNull((Object)((Object)messageType), (String)"messageType is required");
        this.setHeader(MESSAGE_TYPE_HEADER, (Object)messageType);
    }

    protected SimpMessageHeaderAccessor(Message<?> message) {
        super(message);
    }

    public static SimpMessageHeaderAccessor create() {
        return new SimpMessageHeaderAccessor(SimpMessageType.MESSAGE, null);
    }

    public static SimpMessageHeaderAccessor create(SimpMessageType messageType) {
        return new SimpMessageHeaderAccessor(messageType, null);
    }

    public static SimpMessageHeaderAccessor wrap(Message<?> message) {
        return new SimpMessageHeaderAccessor(message);
    }

    public void setMessageTypeIfNotSet(SimpMessageType messageType) {
        if (this.getMessageType() == null) {
            this.setHeader(MESSAGE_TYPE_HEADER, (Object)messageType);
        }
    }

    public SimpMessageType getMessageType() {
        return (SimpMessageType)((Object)this.getHeader(MESSAGE_TYPE_HEADER));
    }

    public void setDestination(String destination) {
        Assert.notNull((Object)destination, (String)"destination is required");
        this.setHeader(DESTINATION_HEADER, destination);
    }

    public String getDestination() {
        return (String)this.getHeader(DESTINATION_HEADER);
    }

    public MediaType getContentType() {
        return (MediaType)this.getHeader("contentType");
    }

    public void setContentType(MediaType contentType) {
        this.setHeader("contentType", contentType);
    }

    public String getSubscriptionId() {
        return (String)this.getHeader(SUBSCRIPTION_ID_HEADER);
    }

    public void setSubscriptionId(String subscriptionId) {
        this.setHeader(SUBSCRIPTION_ID_HEADER, subscriptionId);
    }

    public String getSessionId() {
        return (String)this.getHeader(SESSION_ID_HEADER);
    }

    public void setSessionId(String sessionId) {
        this.setHeader(SESSION_ID_HEADER, sessionId);
    }

    public Principal getUser() {
        return (Principal)this.getHeader(USER_HEADER);
    }

    public void setUser(Principal principal) {
        this.setHeader(USER_HEADER, principal);
    }
}

