/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.method;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.method.HandlerMethodReturnValueHandler;
import org.springframework.util.Assert;

public class HandlerMethodReturnValueHandlerComposite
implements HandlerMethodReturnValueHandler {
    private final List<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();

    public HandlerMethodReturnValueHandlerComposite addHandler(HandlerMethodReturnValueHandler returnValuehandler) {
        this.returnValueHandlers.add(returnValuehandler);
        return this;
    }

    public HandlerMethodReturnValueHandlerComposite addHandlers(List<? extends HandlerMethodReturnValueHandler> handlers) {
        if (handlers != null) {
            for (HandlerMethodReturnValueHandler handlerMethodReturnValueHandler : handlers) {
                this.returnValueHandlers.add(handlerMethodReturnValueHandler);
            }
        }
        return this;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.getReturnValueHandler(returnType) != null;
    }

    private HandlerMethodReturnValueHandler getReturnValueHandler(MethodParameter returnType) {
        for (HandlerMethodReturnValueHandler handler : this.returnValueHandlers) {
            if (!handler.supportsReturnType(returnType)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        Assert.notNull((Object)handler, (String)("Unknown return value type [" + returnType.getParameterType().getName() + "]"));
        handler.handleReturnValue(returnValue, returnType, message);
    }
}

