/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.MessageBody;
import org.springframework.messaging.handler.method.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.converter.MessageConverter;
import org.springframework.util.Assert;

public class MessageBodyMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final MessageConverter<?> converter;

    public MessageBodyMethodArgumentResolver(MessageConverter<?> converter) {
        Assert.notNull(converter, (String)"converter is required");
        this.converter = converter;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return true;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        Object arg = null;
        MessageBody annot = (MessageBody)parameter.getParameterAnnotation(MessageBody.class);
        if (annot == null || annot.required()) {
            Class<?> sourceClass = message.getPayload().getClass();
            Class targetClass = parameter.getParameterType();
            if (targetClass.isAssignableFrom(sourceClass)) {
                return message.getPayload();
            }
            return this.converter.fromMessage(message, targetClass);
        }
        return arg;
    }
}

