/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.core.AbstractDestinationResolvingMessagingTemplate;
import org.springframework.messaging.core.BeanFactoryMessageChannelDestinationResolver;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class GenericMessagingTemplate
extends AbstractDestinationResolvingMessagingTemplate<MessageChannel>
implements BeanFactoryAware {
    private volatile long sendTimeout = -1L;
    private volatile long receiveTimeout = -1L;
    private volatile boolean throwExceptionOnLateReply = false;

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setThrowExceptionOnLateReply(boolean throwExceptionOnLateReply) {
        this.throwExceptionOnLateReply = throwExceptionOnLateReply;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setDestinationResolver(new BeanFactoryMessageChannelDestinationResolver(beanFactory));
    }

    @Override
    protected final void doSend(MessageChannel destination, Message<?> message) {
        boolean sent;
        Assert.notNull((Object)destination, (String)"channel must not be null");
        long timeout = this.sendTimeout;
        boolean bl = sent = timeout >= 0L ? destination.send(message, timeout) : destination.send(message);
        if (!sent) {
            throw new MessageDeliveryException(message, "failed to send message to channel '" + destination + "' within timeout: " + timeout);
        }
    }

    @Override
    protected final <P> Message<P> doReceive(MessageChannel destination) {
        Message<?> message;
        Assert.state((boolean)(destination instanceof PollableChannel), (String)"The 'destination' must be a PollableChannel for receive operations.");
        Assert.notNull((Object)destination, (String)"channel must not be null");
        long timeout = this.receiveTimeout;
        Message<?> message2 = message = timeout >= 0L ? ((PollableChannel)destination).receive(timeout) : ((PollableChannel)destination).receive();
        if (message == null && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("failed to receive message from channel '" + destination + "' within timeout: " + timeout));
        }
        return message;
    }

    @Override
    protected final <S, R> Message<R> doSendAndReceive(MessageChannel destination, Message<S> requestMessage) {
        Object originalReplyChannelHeader = requestMessage.getHeaders().getReplyChannel();
        Object originalErrorChannelHeader = requestMessage.getHeaders().getErrorChannel();
        TemporaryReplyChannel replyChannel = new TemporaryReplyChannel(this.receiveTimeout, this.throwExceptionOnLateReply);
        requestMessage = MessageBuilder.fromMessage(requestMessage).setReplyChannel(replyChannel).setErrorChannel(replyChannel).build();
        try {
            this.doSend(destination, requestMessage);
        }
        catch (RuntimeException e) {
            replyChannel.setClientWontReceive(true);
            throw e;
        }
        Message reply = this.doReceive(replyChannel);
        if (reply != null) {
            reply = MessageBuilder.fromMessage(reply).setHeader("replyChannel", originalReplyChannelHeader).setHeader("errorChannel", originalErrorChannelHeader).build();
        }
        return reply;
    }

    private static class TemporaryReplyChannel
    implements PollableChannel {
        private static final Log logger = LogFactory.getLog(TemporaryReplyChannel.class);
        private volatile Message<?> message;
        private final long receiveTimeout;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final boolean throwExceptionOnLateReply;
        private volatile boolean clientTimedOut;
        private volatile boolean clientWontReceive;
        private volatile boolean clientHasReceived;

        public TemporaryReplyChannel(long receiveTimeout, boolean throwExceptionOnLateReply) {
            this.receiveTimeout = receiveTimeout;
            this.throwExceptionOnLateReply = throwExceptionOnLateReply;
        }

        public void setClientWontReceive(boolean clientWontReceive) {
            this.clientWontReceive = clientWontReceive;
        }

        @Override
        public Message<?> receive() {
            return this.receive(-1L);
        }

        @Override
        public Message<?> receive(long timeout) {
            try {
                if (this.receiveTimeout < 0L) {
                    this.latch.await();
                    this.clientHasReceived = true;
                } else if (this.latch.await(this.receiveTimeout, TimeUnit.MILLISECONDS)) {
                    this.clientHasReceived = true;
                } else {
                    this.clientTimedOut = true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.message;
        }

        @Override
        public boolean send(Message<?> message) {
            return this.send(message, -1L);
        }

        @Override
        public boolean send(Message<?> message, long timeout) {
            this.message = message;
            this.latch.countDown();
            if (this.clientTimedOut || this.clientHasReceived || this.clientWontReceive) {
                String exceptionMessage = "";
                if (this.clientTimedOut) {
                    exceptionMessage = "Reply message being sent, but the receiving thread has already timed out";
                } else if (this.clientHasReceived) {
                    exceptionMessage = "Reply message being sent, but the receiving thread has already received a reply";
                } else if (this.clientWontReceive) {
                    exceptionMessage = "Reply message being sent, but the receiving thread has already caught an exception and won't receive";
                }
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)(exceptionMessage + ":" + message));
                }
                if (this.throwExceptionOnLateReply) {
                    throw new MessageDeliveryException(message, exceptionMessage);
                }
            }
            return true;
        }
    }
}

