/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import org.springframework.messaging.Message;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.core.MessageReceivingOperations;
import org.springframework.messaging.core.MessageRequestReplyOperations;

public abstract class AbstractMessagingTemplate<D>
extends AbstractMessageSendingTemplate<D>
implements MessageRequestReplyOperations<D>,
MessageReceivingOperations<D> {
    @Override
    public <P> Message<P> receive() {
        return this.receive(this.getRequiredDefaultDestination());
    }

    @Override
    public <P> Message<P> receive(D destination) {
        return this.doReceive(destination);
    }

    protected abstract <P> Message<P> doReceive(D var1);

    @Override
    public Object receiveAndConvert() {
        return this.receiveAndConvert(this.getRequiredDefaultDestination());
    }

    @Override
    public Object receiveAndConvert(D destination) {
        Message message = this.doReceive(destination);
        return message != null ? this.getConverter().fromMessage(message, null) : null;
    }

    @Override
    public Message<?> sendAndReceive(Message<?> requestMessage) {
        return this.sendAndReceive(this.getRequiredDefaultDestination(), requestMessage);
    }

    @Override
    public Message<?> sendAndReceive(D destination, Message<?> requestMessage) {
        return this.doSendAndReceive(destination, requestMessage);
    }

    protected abstract <S, R> Message<R> doSendAndReceive(D var1, Message<S> var2);

    @Override
    public Object convertSendAndReceive(Object request) {
        return this.convertSendAndReceive(this.getRequiredDefaultDestination(), request);
    }

    @Override
    public Object convertSendAndReceive(D destination, Object request) {
        return this.convertSendAndReceive(destination, request, null);
    }

    @Override
    public Object convertSendAndReceive(Object request, MessagePostProcessor postProcessor) {
        return this.convertSendAndReceive(this.getRequiredDefaultDestination(), request, postProcessor);
    }

    @Override
    public Object convertSendAndReceive(D destination, Object request, MessagePostProcessor postProcessor) {
        Message<Object> requestMessage = this.getConverter().toMessage(request);
        if (postProcessor != null) {
            requestMessage = postProcessor.postProcessMessage(requestMessage);
        }
        Message replyMessage = this.sendAndReceive(destination, requestMessage);
        return this.getConverter().fromMessage(replyMessage, null);
    }
}

