/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.core.MessageSendingOperations;
import org.springframework.messaging.support.converter.MessageConverter;
import org.springframework.messaging.support.converter.SimplePayloadMessageConverter;
import org.springframework.util.Assert;

public abstract class AbstractMessageSendingTemplate<D>
implements MessageSendingOperations<D> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile D defaultDestination;
    private volatile MessageConverter converter = new SimplePayloadMessageConverter();

    public void setDefaultDestination(D defaultDestination) {
        this.defaultDestination = defaultDestination;
    }

    public D getDefaultDestination() {
        return this.defaultDestination;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        this.converter = messageConverter;
    }

    public MessageConverter getConverter() {
        return this.converter;
    }

    public void setConverter(MessageConverter converter) {
        this.converter = converter;
    }

    @Override
    public <P> void send(Message<P> message) {
        this.send(this.getRequiredDefaultDestination(), message);
    }

    protected final D getRequiredDefaultDestination() {
        Assert.state((this.defaultDestination != null ? 1 : 0) != 0, (String)"No 'defaultDestination' specified for MessagingTemplate. Unable to invoke method without an explicit destination argument.");
        return this.defaultDestination;
    }

    @Override
    public <P> void send(D destination, Message<P> message) {
        this.doSend(destination, message);
    }

    protected abstract void doSend(D var1, Message<?> var2);

    @Override
    public <T> void convertAndSend(T message) {
        this.convertAndSend(this.getRequiredDefaultDestination(), message);
    }

    @Override
    public <T> void convertAndSend(D destination, T object) {
        this.convertAndSend(destination, object, null);
    }

    @Override
    public <T> void convertAndSend(T object, MessagePostProcessor postProcessor) {
        this.convertAndSend(this.getRequiredDefaultDestination(), object, postProcessor);
    }

    @Override
    public <T> void convertAndSend(D destination, T object, MessagePostProcessor postProcessor) throws MessagingException {
        Message<Object> message = this.converter.toMessage(object);
        if (postProcessor != null) {
            message = postProcessor.postProcessMessage(message);
        }
        this.send(destination, message);
    }
}

