/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import org.springframework.messaging.Message;
import org.springframework.messaging.core.AbstractMessagingTemplate;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.core.DestinationResolvingMessageReceivingOperations;
import org.springframework.messaging.core.DestinationResolvingMessageRequestReplyOperations;
import org.springframework.messaging.core.DestinationResolvingMessageSendingOperations;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.util.Assert;

public abstract class AbstractDestinationResolvingMessagingTemplate<D>
extends AbstractMessagingTemplate<D>
implements DestinationResolvingMessageSendingOperations<D>,
DestinationResolvingMessageReceivingOperations<D>,
DestinationResolvingMessageRequestReplyOperations<D> {
    private volatile DestinationResolver<D> destinationResolver;

    public void setDestinationResolver(DestinationResolver<D> destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    @Override
    public <P> void send(String destinationName, Message<P> message) {
        D destination = this.resolveDestination(destinationName);
        this.doSend(destination, message);
    }

    protected final D resolveDestination(String destinationName) {
        Assert.notNull(this.destinationResolver, (String)"destinationResolver is required when passing a name only");
        return this.destinationResolver.resolveDestination(destinationName);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T message) {
        this.convertAndSend(destinationName, message, (MessagePostProcessor)null);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T message, MessagePostProcessor postProcessor) {
        D destination = this.resolveDestination(destinationName);
        super.convertAndSend(destination, message, postProcessor);
    }

    @Override
    public <P> Message<P> receive(String destinationName) {
        D destination = this.resolveDestination(destinationName);
        return super.receive(destination);
    }

    @Override
    public Object receiveAndConvert(String destinationName) {
        D destination = this.resolveDestination(destinationName);
        return super.receiveAndConvert(destination);
    }

    @Override
    public Message<?> sendAndReceive(String destinationName, Message<?> requestMessage) {
        D destination = this.resolveDestination(destinationName);
        return super.sendAndReceive(destination, requestMessage);
    }

    @Override
    public Object convertSendAndReceive(String destinationName, Object request) {
        D destination = this.resolveDestination(destinationName);
        return super.convertSendAndReceive(destination, request);
    }

    @Override
    public Object convertSendAndReceive(String destinationName, Object request, MessagePostProcessor postProcessor) {
        D destination = this.resolveDestination(destinationName);
        return super.convertSendAndReceive(destination, request, postProcessor);
    }
}

