/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MessageHeaders
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -4615750558355702881L;
    private static final Log logger = LogFactory.getLog(MessageHeaders.class);
    private static volatile IdGenerator idGenerator = null;
    public static final String ID = "id";
    public static final String TIMESTAMP = "timestamp";
    public static final String REPLY_CHANNEL = "replyChannel";
    public static final String ERROR_CHANNEL = "errorChannel";
    public static final String CONTENT_TYPE = "contentType";
    public static final List<String> HEADER_NAMES = Arrays.asList("id", "timestamp");
    private final Map<String, Object> headers;

    public MessageHeaders(Map<String, Object> headers) {
        Map<String, Object> map = this.headers = headers != null ? new HashMap<String, Object>(headers) : new HashMap();
        if (idGenerator == null) {
            this.headers.put(ID, UUID.randomUUID());
        } else {
            this.headers.put(ID, idGenerator.generateId());
        }
        this.headers.put(TIMESTAMP, new Long(System.currentTimeMillis()));
    }

    public UUID getId() {
        return this.get(ID, UUID.class);
    }

    public Long getTimestamp() {
        return this.get(TIMESTAMP, Long.class);
    }

    public Object getReplyChannel() {
        return this.get(REPLY_CHANNEL);
    }

    public Object getErrorChannel() {
        return this.get(ERROR_CHANNEL);
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.headers.get(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for header '" + key + "'. Expected [" + type + "] but actual type is [" + value.getClass() + "]");
        }
        return (T)value;
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof MessageHeaders) {
            MessageHeaders other = (MessageHeaders)object;
            return this.headers.equals(other.headers);
        }
        return false;
    }

    public String toString() {
        return this.headers.toString();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.headers.entrySet());
    }

    @Override
    public Object get(Object key) {
        return this.headers.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.headers.values());
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("MessageHeaders is immutable.");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException("MessageHeaders is immutable.");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("MessageHeaders is immutable.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("MessageHeaders is immutable.");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            if (entry.getValue() instanceof Serializable) continue;
            keysToRemove.add(entry.getKey());
        }
        for (String key : keysToRemove) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("removing non-serializable header: " + key));
            }
            this.headers.remove(key);
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public static interface IdGenerator {
        public UUID generateId();
    }
}

