/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultMessageListenerContainer
extends AbstractMessageListenerContainer {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName((Class)(class$org$springframework$jms$listener$DefaultMessageListenerContainer == null ? (class$org$springframework$jms$listener$DefaultMessageListenerContainer = DefaultMessageListenerContainer.class$("org.springframework.jms.listener.DefaultMessageListenerContainer")) : class$org$springframework$jms$listener$DefaultMessageListenerContainer)) + "-";
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    public static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    private boolean pubSubNoLocal = false;
    private TaskExecutor taskExecutor;
    private int concurrentConsumers = 1;
    private int maxMessagesPerTask = Integer.MIN_VALUE;
    private PlatformTransactionManager transactionManager;
    private DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    private long receiveTimeout = 1000L;
    private long recoveryInterval = 5000L;
    private boolean cacheSessions = true;
    static /* synthetic */ Class class$org$springframework$jms$listener$DefaultMessageListenerContainer;

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    protected boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue((concurrentConsumers > 0 ? 1 : 0) != 0, (String)"concurrentConsumers must be positive");
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        Assert.isTrue((maxMessagesPerTask != 0 ? 1 : 0) != 0, (String)"maxMessagesPerTask must not be 0");
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionDefinition.setTimeout(transactionTimeout);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setCacheSessions(boolean cacheSessions) {
        this.cacheSessions = cacheSessions;
    }

    public void initialize() {
        if (this.taskExecutor == null) {
            this.taskExecutor = new SimpleAsyncTaskExecutor(DEFAULT_THREAD_NAME_PREFIX);
        } else if (this.taskExecutor instanceof SchedulingTaskExecutor && ((SchedulingTaskExecutor)this.taskExecutor).isShortLivedPreferred() && this.maxMessagesPerTask == Integer.MIN_VALUE) {
            this.maxMessagesPerTask = 1;
        }
        super.initialize();
    }

    protected void registerListener() throws JMSException {
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            this.taskExecutor.execute((Runnable)((Object)new AsyncMessageListenerInvoker()));
        }
    }

    protected MessageConsumer createListenerConsumer(Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        return this.createConsumer(session, destination);
    }

    protected void executeListener(Session session, MessageConsumer consumer) throws JMSException {
        if (this.transactionManager != null) {
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)this.transactionDefinition);
            try {
                Message message = this.receiveMessage(consumer);
                if (message != null) {
                    try {
                        this.doExecuteListener(session, message);
                    }
                    catch (Throwable ex) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Rolling back transaction because of listener exception thrown: " + ex));
                        }
                        status.setRollbackOnly();
                        this.handleListenerException(ex);
                    }
                }
            }
            catch (JMSException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                this.rollbackOnException(status, ex);
                throw ex;
            }
            catch (Error err) {
                this.rollbackOnException(status, err);
                throw err;
            }
            this.transactionManager.commit(status);
        } else {
            Message message = this.receiveMessage(consumer);
            if (message != null) {
                this.executeListener(session, message);
            }
        }
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) {
        this.logger.debug((Object)"Initiating transaction rollback on application exception", ex);
        try {
            this.transactionManager.rollback(status);
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)"Application exception overridden by rollback error", ex);
            throw err;
        }
    }

    protected Message receiveMessage(MessageConsumer consumer) throws JMSException {
        return this.receiveTimeout < 0L ? consumer.receive() : consumer.receive(this.receiveTimeout);
    }

    protected void handleListenerSetupFailure(Throwable ex) {
        if (ex instanceof JMSException) {
            this.invokeExceptionListener((JMSException)ex);
        }
        this.logger.error((Object)"Setup of JMS message listener invoker failed", ex);
        if (this.recoveryInterval > 0L) {
            try {
                Thread.sleep(this.recoveryInterval);
            }
            catch (InterruptedException interEx) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void destroyListener() throws JMSException {
        this.logger.debug((Object)"Shutting down JMS message listener invokers");
        if (this.receiveTimeout > 0L) {
            try {
                Thread.sleep(this.receiveTimeout);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            return session.createConsumer(destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AsyncMessageListenerInvoker
    implements SchedulingAwareRunnable {
        private Session session;
        private MessageConsumer consumer;

        private AsyncMessageListenerInvoker() {
        }

        public void run() {
            try {
                if (DefaultMessageListenerContainer.this.maxMessagesPerTask < 0) {
                    while (DefaultMessageListenerContainer.this.isActive()) {
                        this.invokeListener();
                    }
                } else {
                    for (int messageCount = 0; DefaultMessageListenerContainer.this.isActive() && messageCount < DefaultMessageListenerContainer.this.maxMessagesPerTask; ++messageCount) {
                        this.invokeListener();
                    }
                }
            }
            catch (Throwable ex) {
                this.clearResources();
                DefaultMessageListenerContainer.this.handleListenerSetupFailure(ex);
            }
            if (DefaultMessageListenerContainer.this.isActive()) {
                DefaultMessageListenerContainer.this.taskExecutor.execute((Runnable)((Object)this));
            } else {
                this.clearResources();
            }
        }

        private void invokeListener() throws JMSException {
            this.initResourcesIfNecessary();
            DefaultMessageListenerContainer.this.executeListener(this.session, this.consumer);
            if (!DefaultMessageListenerContainer.this.cacheSessions) {
                this.clearResources();
            }
        }

        private void initResourcesIfNecessary() throws JMSException {
            if (this.session == null) {
                this.session = DefaultMessageListenerContainer.this.createSession(DefaultMessageListenerContainer.this.getConnection());
                this.consumer = DefaultMessageListenerContainer.this.createListenerConsumer(this.session);
            }
        }

        private void clearResources() {
            JmsUtils.closeMessageConsumer(this.consumer);
            JmsUtils.closeSession(this.session);
            this.consumer = null;
            this.session = null;
        }

        public boolean isLongLived() {
            return DefaultMessageListenerContainer.this.maxMessagesPerTask < 0;
        }
    }
}

