/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SimplePropertyRowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SimplePropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.JdbcClient;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.util.Assert;

final class DefaultJdbcClient
implements JdbcClient {
    private final NamedParameterJdbcOperations namedParamOps;
    private final ConversionService conversionService;
    private final Map<Class<?>, RowMapper<?>> rowMapperCache = new ConcurrentHashMap();

    public DefaultJdbcClient(DataSource dataSource) {
        this(new JdbcTemplate(dataSource));
    }

    public DefaultJdbcClient(JdbcOperations jdbcTemplate) {
        this(new NamedParameterJdbcTemplate(jdbcTemplate), null);
    }

    public DefaultJdbcClient(NamedParameterJdbcOperations jdbcTemplate, @Nullable ConversionService conversionService) {
        Assert.notNull((Object)jdbcTemplate, (String)"NamedParameterJdbcTemplate must not be null");
        this.namedParamOps = jdbcTemplate;
        this.conversionService = conversionService != null ? conversionService : DefaultConversionService.getSharedInstance();
    }

    @Override
    public JdbcClient.StatementSpec sql(String sql) {
        return new DefaultStatementSpec(sql, this.namedParamOps);
    }

    private class DefaultStatementSpec
    implements JdbcClient.StatementSpec {
        private final String sql;
        private JdbcOperations classicOps;
        private NamedParameterJdbcOperations namedParamOps;
        private @Nullable JdbcTemplate customTemplate;
        private final List<@Nullable Object> indexedParams = new ArrayList<Object>();
        private final MapSqlParameterSource namedParams = new MapSqlParameterSource();
        private SqlParameterSource namedParamSource = this.namedParams;

        public DefaultStatementSpec(String sql, NamedParameterJdbcOperations namedParamOps) {
            this.sql = sql;
            this.classicOps = namedParamOps.getJdbcOperations();
            this.namedParamOps = namedParamOps;
        }

        private JdbcTemplate enforceCustomTemplate() {
            if (this.customTemplate == null) {
                NamedParameterJdbcTemplate namedParameterJdbcTemplate;
                JdbcOperations jdbcOperations = this.classicOps;
                if (!(jdbcOperations instanceof JdbcAccessor)) {
                    throw new IllegalStateException("Needs to be bound to a JdbcAccessor for custom settings support: " + String.valueOf(this.classicOps));
                }
                JdbcAccessor original = (JdbcAccessor)((Object)jdbcOperations);
                this.customTemplate = new JdbcTemplate(original);
                this.classicOps = this.customTemplate;
                NamedParameterJdbcOperations namedParameterJdbcOperations = this.namedParamOps;
                if (namedParameterJdbcOperations instanceof NamedParameterJdbcTemplate) {
                    NamedParameterJdbcTemplate originalNamedParam = (NamedParameterJdbcTemplate)namedParameterJdbcOperations;
                    namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(originalNamedParam, this.customTemplate);
                } else {
                    namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.customTemplate);
                }
                this.namedParamOps = namedParameterJdbcTemplate;
            }
            return this.customTemplate;
        }

        @Override
        public JdbcClient.StatementSpec withFetchSize(int fetchSize) {
            this.enforceCustomTemplate().setFetchSize(fetchSize);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec withMaxRows(int maxRows) {
            this.enforceCustomTemplate().setMaxRows(maxRows);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec withQueryTimeout(int queryTimeout) {
            this.enforceCustomTemplate().setQueryTimeout(queryTimeout);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec param(@Nullable Object value) {
            this.validateIndexedParamValue(value);
            this.indexedParams.add(value);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec param(int jdbcIndex, @Nullable Object value) {
            if (jdbcIndex < 1) {
                throw new IllegalArgumentException("Invalid JDBC index: needs to start at 1");
            }
            this.validateIndexedParamValue(value);
            int index = jdbcIndex - 1;
            int size = this.indexedParams.size();
            if (index < size) {
                this.indexedParams.set(index, value);
            } else {
                for (int i = size; i < index; ++i) {
                    this.indexedParams.add(null);
                }
                this.indexedParams.add(value);
            }
            return this;
        }

        private void validateIndexedParamValue(@Nullable Object value) {
            if (value instanceof Iterable) {
                throw new IllegalArgumentException("Invalid positional parameter value of type Iterable (" + value.getClass().getSimpleName() + "): Parameter expansion is only supported with named parameters.");
            }
        }

        @Override
        public JdbcClient.StatementSpec param(int jdbcIndex, @Nullable Object value, int sqlType) {
            return this.param(jdbcIndex, (Object)new SqlParameterValue(sqlType, value));
        }

        @Override
        public JdbcClient.StatementSpec param(String name, @Nullable Object value) {
            this.namedParams.addValue(name, value);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec param(String name, @Nullable Object value, int sqlType) {
            this.namedParams.addValue(name, value, sqlType);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec params(Object ... values) {
            Collections.addAll(this.indexedParams, values);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec params(List<?> values) {
            this.indexedParams.addAll(values);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec params(Map<String, ?> paramMap) {
            this.namedParams.addValues(paramMap);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec paramSource(Object namedParamObject) {
            AbstractSqlParameterSource abstractSqlParameterSource;
            if (namedParamObject instanceof Map) {
                Map map = (Map)namedParamObject;
                abstractSqlParameterSource = new MapSqlParameterSource(map);
            } else {
                abstractSqlParameterSource = new SimplePropertySqlParameterSource(namedParamObject);
            }
            this.namedParamSource = abstractSqlParameterSource;
            return this;
        }

        @Override
        public JdbcClient.StatementSpec paramSource(SqlParameterSource namedParamSource) {
            this.namedParamSource = namedParamSource;
            return this;
        }

        @Override
        public JdbcClient.ResultQuerySpec query() {
            return this.useNamedParams() ? new NamedParamResultQuerySpec() : new IndexedParamResultQuerySpec();
        }

        @Override
        public <T> JdbcClient.MappedQuerySpec<@Nullable T> query(Class<T> mappedClass) {
            RowMapper rowMapper = DefaultJdbcClient.this.rowMapperCache.computeIfAbsent(mappedClass, key -> BeanUtils.isSimpleProperty((Class)mappedClass) ? new SingleColumnRowMapper(mappedClass, DefaultJdbcClient.this.conversionService) : new SimplePropertyRowMapper(mappedClass, DefaultJdbcClient.this.conversionService));
            return this.query(rowMapper);
        }

        @Override
        public <T> JdbcClient.MappedQuerySpec<T> query(RowMapper<T> rowMapper) {
            return this.useNamedParams() ? new NamedParamMappedQuerySpec<T>(rowMapper) : new IndexedParamMappedQuerySpec<T>(rowMapper);
        }

        @Override
        public void query(RowCallbackHandler rch) {
            if (this.useNamedParams()) {
                this.namedParamOps.query(this.sql, this.namedParamSource, rch);
            } else {
                this.classicOps.query(this.statementCreatorForIndexedParams(), rch);
            }
        }

        @Override
        public <T> T query(ResultSetExtractor<T> rse) {
            T result = this.useNamedParams() ? this.namedParamOps.query(this.sql, this.namedParamSource, rse) : this.classicOps.query(this.statementCreatorForIndexedParams(), rse);
            Assert.state((result != null ? 1 : 0) != 0, (String)"No result from ResultSetExtractor");
            return result;
        }

        @Override
        public int update() {
            return this.useNamedParams() ? this.namedParamOps.update(this.sql, this.namedParamSource) : this.classicOps.update(this.statementCreatorForIndexedParams());
        }

        @Override
        public int update(KeyHolder generatedKeyHolder) {
            return this.useNamedParams() ? this.namedParamOps.update(this.sql, this.namedParamSource, generatedKeyHolder) : this.classicOps.update(this.statementCreatorForIndexedParamsWithKeys(null), generatedKeyHolder);
        }

        @Override
        public int update(KeyHolder generatedKeyHolder, String ... keyColumnNames) {
            return this.useNamedParams() ? this.namedParamOps.update(this.sql, this.namedParamSource, generatedKeyHolder, keyColumnNames) : this.classicOps.update(this.statementCreatorForIndexedParamsWithKeys(keyColumnNames), generatedKeyHolder);
        }

        private boolean useNamedParams() {
            boolean hasNamedParams;
            boolean bl = hasNamedParams = this.namedParams.hasValues() || this.namedParamSource != this.namedParams;
            if (hasNamedParams && !this.indexedParams.isEmpty()) {
                throw new IllegalStateException("Configure either named or indexed parameters, not both");
            }
            if (this.namedParams.hasValues() && this.namedParamSource != this.namedParams) {
                throw new IllegalStateException("Configure either individual named parameters or a SqlParameterSource, not both");
            }
            return hasNamedParams;
        }

        private PreparedStatementCreator statementCreatorForIndexedParams() {
            return new PreparedStatementCreatorFactory(this.sql).newPreparedStatementCreator(this.indexedParams);
        }

        private PreparedStatementCreator statementCreatorForIndexedParamsWithKeys(String @Nullable [] keyColumnNames) {
            PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(this.sql);
            if (keyColumnNames != null) {
                pscf.setGeneratedKeysColumnNames(keyColumnNames);
            } else {
                pscf.setReturnGeneratedKeys(true);
            }
            return pscf.newPreparedStatementCreator(this.indexedParams);
        }

        private class NamedParamResultQuerySpec
        implements JdbcClient.ResultQuerySpec {
            private NamedParamResultQuerySpec() {
            }

            @Override
            public SqlRowSet rowSet() {
                return DefaultStatementSpec.this.namedParamOps.queryForRowSet(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource);
            }

            @Override
            public List<Map<String, @Nullable Object>> listOfRows() {
                return DefaultStatementSpec.this.namedParamOps.queryForList(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource);
            }

            @Override
            public Map<String, @Nullable Object> singleRow() {
                return DefaultStatementSpec.this.namedParamOps.queryForMap(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource);
            }

            @Override
            public List<@Nullable Object> singleColumn() {
                return DefaultStatementSpec.this.namedParamOps.queryForList(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource, Object.class);
            }
        }

        private class IndexedParamResultQuerySpec
        implements JdbcClient.ResultQuerySpec {
            private IndexedParamResultQuerySpec() {
            }

            @Override
            public SqlRowSet rowSet() {
                return DefaultStatementSpec.this.classicOps.queryForRowSet(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.indexedParams.toArray());
            }

            @Override
            public List<Map<String, @Nullable Object>> listOfRows() {
                return DefaultStatementSpec.this.classicOps.queryForList(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.indexedParams.toArray());
            }

            @Override
            public Map<String, @Nullable Object> singleRow() {
                return DefaultStatementSpec.this.classicOps.queryForMap(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.indexedParams.toArray());
            }

            @Override
            public List<@Nullable Object> singleColumn() {
                return DefaultStatementSpec.this.classicOps.queryForList(DefaultStatementSpec.this.sql, Object.class, DefaultStatementSpec.this.indexedParams.toArray());
            }
        }

        private class NamedParamMappedQuerySpec<T>
        implements JdbcClient.MappedQuerySpec<T> {
            private final RowMapper<T> rowMapper;

            public NamedParamMappedQuerySpec(RowMapper<T> rowMapper) {
                this.rowMapper = rowMapper;
            }

            @Override
            public Stream<T> stream() {
                return DefaultStatementSpec.this.namedParamOps.queryForStream(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource, this.rowMapper);
            }

            @Override
            public List<T> list() {
                return DefaultStatementSpec.this.namedParamOps.query(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource, this.rowMapper);
            }
        }

        private class IndexedParamMappedQuerySpec<T>
        implements JdbcClient.MappedQuerySpec<T> {
            private final RowMapper<T> rowMapper;

            public IndexedParamMappedQuerySpec(RowMapper<T> rowMapper) {
                this.rowMapper = rowMapper;
            }

            @Override
            public Stream<T> stream() {
                return DefaultStatementSpec.this.classicOps.queryForStream(DefaultStatementSpec.this.sql, this.rowMapper, DefaultStatementSpec.this.indexedParams.toArray());
            }

            @Override
            public List<T> list() {
                return DefaultStatementSpec.this.classicOps.query(DefaultStatementSpec.this.sql, this.rowMapper, DefaultStatementSpec.this.indexedParams.toArray());
            }
        }
    }
}

