/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jspecify.annotations.Nullable;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.support.JdbcUtils;

public class RowCountCallbackHandler
implements RowCallbackHandler {
    private int rowCount;
    private int columnCount;
    private int @Nullable [] columnTypes;
    private String @Nullable [] columnNames;

    @Override
    public final void processRow(ResultSet rs) throws SQLException {
        if (this.rowCount == 0) {
            ResultSetMetaData rsmd = rs.getMetaData();
            this.columnCount = rsmd.getColumnCount();
            this.columnTypes = new int[this.columnCount];
            this.columnNames = new String[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                this.columnTypes[i] = rsmd.getColumnType(i + 1);
                this.columnNames[i] = JdbcUtils.lookupColumnName(rsmd, i + 1);
            }
        }
        this.processRow(rs, this.rowCount++);
    }

    protected void processRow(ResultSet rs, int rowNum) throws SQLException {
    }

    public final int @Nullable [] getColumnTypes() {
        return this.columnTypes;
    }

    public final String @Nullable [] getColumnNames() {
        return this.columnNames;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final int getColumnCount() {
        return this.columnCount;
    }
}

