/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SimplePropertyRowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SimplePropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.JdbcClient;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class DefaultJdbcClient
implements JdbcClient {
    private final JdbcOperations classicOps;
    private final NamedParameterJdbcOperations namedParamOps;
    private final Map<Class<?>, RowMapper<?>> rowMapperCache = new ConcurrentHashMap();

    public DefaultJdbcClient(DataSource dataSource) {
        this.classicOps = new JdbcTemplate(dataSource);
        this.namedParamOps = new NamedParameterJdbcTemplate(this.classicOps);
    }

    public DefaultJdbcClient(JdbcOperations jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate, (String)"JdbcTemplate must not be null");
        this.classicOps = jdbcTemplate;
        this.namedParamOps = new NamedParameterJdbcTemplate(jdbcTemplate);
    }

    public DefaultJdbcClient(NamedParameterJdbcOperations jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate, (String)"JdbcTemplate must not be null");
        this.classicOps = jdbcTemplate.getJdbcOperations();
        this.namedParamOps = jdbcTemplate;
    }

    @Override
    public JdbcClient.StatementSpec sql(String sql) {
        return new DefaultStatementSpec(sql);
    }

    private class DefaultStatementSpec
    implements JdbcClient.StatementSpec {
        private final String sql;
        private final List<Object> indexedParams = new ArrayList<Object>();
        private final MapSqlParameterSource namedParams = new MapSqlParameterSource();
        private SqlParameterSource namedParamSource = this.namedParams;

        public DefaultStatementSpec(String sql) {
            this.sql = sql;
        }

        @Override
        public JdbcClient.StatementSpec param(@Nullable Object value) {
            this.validateIndexedParamValue(value);
            this.indexedParams.add(value);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec param(int jdbcIndex, @Nullable Object value) {
            if (jdbcIndex < 1) {
                throw new IllegalArgumentException("Invalid JDBC index: needs to start at 1");
            }
            this.validateIndexedParamValue(value);
            int index = jdbcIndex - 1;
            int size = this.indexedParams.size();
            if (index < size) {
                this.indexedParams.set(index, value);
            } else {
                for (int i = size; i < index; ++i) {
                    this.indexedParams.add(null);
                }
                this.indexedParams.add(value);
            }
            return this;
        }

        private void validateIndexedParamValue(@Nullable Object value) {
            if (value instanceof Iterable) {
                throw new IllegalArgumentException("Invalid positional parameter value of type Iterable (" + value.getClass().getSimpleName() + "): Parameter expansion is only supported with named parameters.");
            }
        }

        @Override
        public JdbcClient.StatementSpec param(int jdbcIndex, @Nullable Object value, int sqlType) {
            return this.param(jdbcIndex, (Object)new SqlParameterValue(sqlType, value));
        }

        @Override
        public JdbcClient.StatementSpec param(String name, @Nullable Object value) {
            this.namedParams.addValue(name, value);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec param(String name, @Nullable Object value, int sqlType) {
            this.namedParams.addValue(name, value, sqlType);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec params(Object ... values) {
            Collections.addAll(this.indexedParams, values);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec params(List<?> values) {
            this.indexedParams.addAll(values);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec params(Map<String, ?> paramMap) {
            this.namedParams.addValues(paramMap);
            return this;
        }

        @Override
        public JdbcClient.StatementSpec paramSource(Object namedParamObject) {
            AbstractSqlParameterSource abstractSqlParameterSource;
            if (namedParamObject instanceof Map) {
                Map map = (Map)namedParamObject;
                abstractSqlParameterSource = new MapSqlParameterSource(map);
            } else {
                abstractSqlParameterSource = new SimplePropertySqlParameterSource(namedParamObject);
            }
            this.namedParamSource = abstractSqlParameterSource;
            return this;
        }

        @Override
        public JdbcClient.StatementSpec paramSource(SqlParameterSource namedParamSource) {
            this.namedParamSource = namedParamSource;
            return this;
        }

        @Override
        public JdbcClient.ResultQuerySpec query() {
            return this.useNamedParams() ? new NamedParamResultQuerySpec() : new IndexedParamResultQuerySpec();
        }

        @Override
        public <T> JdbcClient.MappedQuerySpec<T> query(Class<T> mappedClass) {
            RowMapper rowMapper = DefaultJdbcClient.this.rowMapperCache.computeIfAbsent(mappedClass, key -> BeanUtils.isSimpleProperty((Class)mappedClass) ? new SingleColumnRowMapper(mappedClass) : new SimplePropertyRowMapper(mappedClass));
            return this.query(rowMapper);
        }

        @Override
        public <T> JdbcClient.MappedQuerySpec<T> query(RowMapper<T> rowMapper) {
            return this.useNamedParams() ? new NamedParamMappedQuerySpec<T>(rowMapper) : new IndexedParamMappedQuerySpec<T>(rowMapper);
        }

        @Override
        public void query(RowCallbackHandler rch) {
            if (this.useNamedParams()) {
                DefaultJdbcClient.this.namedParamOps.query(this.sql, this.namedParamSource, rch);
            } else {
                DefaultJdbcClient.this.classicOps.query(this.getPreparedStatementCreatorForIndexedParams(), rch);
            }
        }

        @Override
        public <T> T query(ResultSetExtractor<T> rse) {
            T result = this.useNamedParams() ? DefaultJdbcClient.this.namedParamOps.query(this.sql, this.namedParamSource, rse) : DefaultJdbcClient.this.classicOps.query(this.getPreparedStatementCreatorForIndexedParams(), rse);
            Assert.state((result != null ? 1 : 0) != 0, (String)"No result from ResultSetExtractor");
            return result;
        }

        @Override
        public int update() {
            return this.useNamedParams() ? DefaultJdbcClient.this.namedParamOps.update(this.sql, this.namedParamSource) : DefaultJdbcClient.this.classicOps.update(this.getPreparedStatementCreatorForIndexedParams());
        }

        @Override
        public int update(KeyHolder generatedKeyHolder) {
            return this.useNamedParams() ? DefaultJdbcClient.this.namedParamOps.update(this.sql, this.namedParamSource, generatedKeyHolder) : DefaultJdbcClient.this.classicOps.update(this.getPreparedStatementCreatorForIndexedParams(), generatedKeyHolder);
        }

        private boolean useNamedParams() {
            boolean hasNamedParams;
            boolean bl = hasNamedParams = this.namedParams.hasValues() || this.namedParamSource != this.namedParams;
            if (hasNamedParams && !this.indexedParams.isEmpty()) {
                throw new IllegalStateException("Configure either named or indexed parameters, not both");
            }
            if (this.namedParams.hasValues() && this.namedParamSource != this.namedParams) {
                throw new IllegalStateException("Configure either individual named parameters or a SqlParameterSource, not both");
            }
            return hasNamedParams;
        }

        private PreparedStatementCreator getPreparedStatementCreatorForIndexedParams() {
            return new PreparedStatementCreatorFactory(this.sql).newPreparedStatementCreator(this.indexedParams);
        }

        private class NamedParamResultQuerySpec
        implements JdbcClient.ResultQuerySpec {
            private NamedParamResultQuerySpec() {
            }

            @Override
            public SqlRowSet rowSet() {
                return DefaultJdbcClient.this.namedParamOps.queryForRowSet(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource);
            }

            @Override
            public List<Map<String, Object>> listOfRows() {
                return DefaultJdbcClient.this.namedParamOps.queryForList(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource);
            }

            @Override
            public Map<String, Object> singleRow() {
                return DefaultJdbcClient.this.namedParamOps.queryForMap(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource);
            }

            @Override
            public <T> List<T> singleColumn() {
                return DefaultJdbcClient.this.namedParamOps.queryForList(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource, Object.class);
            }
        }

        private class IndexedParamResultQuerySpec
        implements JdbcClient.ResultQuerySpec {
            private IndexedParamResultQuerySpec() {
            }

            @Override
            public SqlRowSet rowSet() {
                return DefaultJdbcClient.this.classicOps.queryForRowSet(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.indexedParams.toArray());
            }

            @Override
            public List<Map<String, Object>> listOfRows() {
                return DefaultJdbcClient.this.classicOps.queryForList(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.indexedParams.toArray());
            }

            @Override
            public Map<String, Object> singleRow() {
                return DefaultJdbcClient.this.classicOps.queryForMap(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.indexedParams.toArray());
            }

            @Override
            public <T> List<T> singleColumn() {
                return DefaultJdbcClient.this.classicOps.queryForList(DefaultStatementSpec.this.sql, Object.class, DefaultStatementSpec.this.indexedParams.toArray());
            }
        }

        private class NamedParamMappedQuerySpec<T>
        implements JdbcClient.MappedQuerySpec<T> {
            private final RowMapper<T> rowMapper;

            public NamedParamMappedQuerySpec(RowMapper<T> rowMapper) {
                this.rowMapper = rowMapper;
            }

            @Override
            public Stream<T> stream() {
                return DefaultJdbcClient.this.namedParamOps.queryForStream(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource, this.rowMapper);
            }

            @Override
            public List<T> list() {
                return DefaultJdbcClient.this.namedParamOps.query(DefaultStatementSpec.this.sql, DefaultStatementSpec.this.namedParamSource, this.rowMapper);
            }
        }

        private class IndexedParamMappedQuerySpec<T>
        implements JdbcClient.MappedQuerySpec<T> {
            private final RowMapper<T> rowMapper;

            public IndexedParamMappedQuerySpec(RowMapper<T> rowMapper) {
                this.rowMapper = rowMapper;
            }

            @Override
            public Stream<T> stream() {
                return DefaultJdbcClient.this.classicOps.queryForStream(DefaultStatementSpec.this.sql, this.rowMapper, DefaultStatementSpec.this.indexedParams.toArray());
            }

            @Override
            public List<T> list() {
                return DefaultJdbcClient.this.classicOps.query(DefaultStatementSpec.this.sql, this.rowMapper, DefaultStatementSpec.this.indexedParams.toArray());
            }
        }
    }
}

