/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class SQLErrorCodesFactory {
    public static final String SQL_ERROR_CODE_OVERRIDE_PATH = "sql-error-codes.xml";
    public static final String SQL_ERROR_CODE_DEFAULT_PATH = "org/springframework/jdbc/support/sql-error-codes.xml";
    private static final Log logger = LogFactory.getLog((Class)SQLErrorCodesFactory.class);
    private static final SQLErrorCodesFactory instance = new SQLErrorCodesFactory();
    private final Map errorCodesMap;
    private final Map dataSourceCache = new WeakHashMap(16);

    public static SQLErrorCodesFactory getInstance() {
        return instance;
    }

    protected SQLErrorCodesFactory() {
        Map errorCodes = null;
        try {
            DefaultListableBeanFactory lbf = new DefaultListableBeanFactory();
            XmlBeanDefinitionReader bdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)lbf);
            Resource resource = this.loadResource(SQL_ERROR_CODE_DEFAULT_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
            } else {
                logger.warn((Object)"Default sql-error-codes.xml not found (should be included in spring.jar)");
            }
            resource = this.loadResource(SQL_ERROR_CODE_OVERRIDE_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
                logger.info((Object)"Found custom sql-error-codes.xml file at the root of the classpath");
            }
            errorCodes = lbf.getBeansOfType(SQLErrorCodes.class, true, false);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("SQLErrorCodes loaded: " + errorCodes.keySet()));
            }
        }
        catch (BeansException ex) {
            logger.warn((Object)"Error loading SQL error codes from config file", (Throwable)ex);
            errorCodes = Collections.EMPTY_MAP;
        }
        this.errorCodesMap = errorCodes;
    }

    protected Resource loadResource(String path) {
        return new ClassPathResource(path, this.getClass().getClassLoader());
    }

    public SQLErrorCodes getErrorCodes(String dbName) {
        Assert.notNull((Object)dbName, (String)"Database product name must not be null");
        SQLErrorCodes sec = (SQLErrorCodes)this.errorCodesMap.get(dbName);
        if (sec == null) {
            Iterator it = this.errorCodesMap.values().iterator();
            while (it.hasNext()) {
                SQLErrorCodes candidate = (SQLErrorCodes)it.next();
                if (!PatternMatchUtils.simpleMatch((String[])candidate.getDatabaseProductNames(), (String)dbName)) continue;
                sec = candidate;
                break;
            }
        }
        if (sec != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SQL error codes for '" + dbName + "' found"));
            }
            return sec;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SQL error codes for '" + dbName + "' not found"));
        }
        return new SQLErrorCodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLErrorCodes getErrorCodes(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"DataSource must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking up default SQLErrorCodes for DataSource [" + dataSource + "]"));
        }
        Map map = this.dataSourceCache;
        synchronized (map) {
            SQLErrorCodes sec = (SQLErrorCodes)this.dataSourceCache.get(dataSource);
            if (sec != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SQLErrorCodes found in cache for DataSource [" + dataSource.getClass().getName() + '@' + Integer.toHexString(dataSource.hashCode()) + "]"));
                }
                return sec;
            }
            try {
                String dbName = (String)JdbcUtils.extractDatabaseMetaData(dataSource, "getDatabaseProductName");
                if (dbName != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Database product name cached for DataSource [" + dataSource.getClass().getName() + '@' + Integer.toHexString(dataSource.hashCode()) + "]: name is '" + dbName + "'"));
                    }
                    sec = this.getErrorCodes(dbName);
                    this.dataSourceCache.put(dataSource, sec);
                    return sec;
                }
            }
            catch (MetaDataAccessException ex) {
                logger.warn((Object)"Error while extracting database product name - falling back to empty error codes", (Throwable)((Object)ex));
            }
        }
        return new SQLErrorCodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLErrorCodes registerDatabase(DataSource dataSource, String dbName) {
        Map map = this.dataSourceCache;
        synchronized (map) {
            SQLErrorCodes sec = this.getErrorCodes(dbName);
            this.dataSourceCache.put(dataSource, sec);
            return sec;
        }
    }
}

