/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.sql.SQLException;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate.SessionFactoryUtils;

@Deprecated
public abstract class HibernateAccessor
implements InitializingBean,
BeanFactoryAware {
    public static final int FLUSH_NEVER = 0;
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EAGER = 2;
    public static final int FLUSH_COMMIT = 3;
    private static final Constants constants = new Constants(HibernateAccessor.class);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;
    private Object entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private int flushMode = 1;
    private BeanFactory beanFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setEntityInterceptorBeanName(String entityInterceptorBeanName) {
        this.entityInterceptor = entityInterceptorBeanName;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() throws IllegalStateException, BeansException {
        if (this.entityInterceptor instanceof String) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("Cannot get entity interceptor via bean name if no bean factory set");
            }
            return (Interceptor)this.beanFactory.getBean((String)this.entityInterceptor, Interceptor.class);
        }
        return (Interceptor)this.entityInterceptor;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public synchronized SQLExceptionTranslator getJdbcExceptionTranslator() {
        if (this.jdbcExceptionTranslator == null) {
            this.jdbcExceptionTranslator = SessionFactoryUtils.newJdbcExceptionTranslator(this.getSessionFactory());
        }
        return this.jdbcExceptionTranslator;
    }

    public void setFlushModeName(String constantName) {
        this.setFlushMode(constants.asNumber(constantName).intValue());
    }

    public void setFlushMode(int flushMode) {
        this.flushMode = flushMode;
    }

    public int getFlushMode() {
        return this.flushMode;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
    }

    protected FlushMode applyFlushMode(Session session, boolean existingTransaction) {
        if (this.getFlushMode() == 0) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getFlushMode();
                if (!previousFlushMode.equals(FlushMode.NEVER)) {
                    session.setFlushMode(FlushMode.NEVER);
                    return previousFlushMode;
                }
            } else {
                session.setFlushMode(FlushMode.NEVER);
            }
        } else if (this.getFlushMode() == 2) {
            FlushMode previousFlushMode;
            if (existingTransaction && !(previousFlushMode = session.getFlushMode()).equals(FlushMode.AUTO)) {
                session.setFlushMode(FlushMode.AUTO);
                return previousFlushMode;
            }
        } else if (this.getFlushMode() == 3) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getFlushMode();
                if (previousFlushMode.equals(FlushMode.AUTO)) {
                    session.setFlushMode(FlushMode.COMMIT);
                    return previousFlushMode;
                }
            } else {
                session.setFlushMode(FlushMode.COMMIT);
            }
        }
        return null;
    }

    protected void flushIfNecessary(Session session, boolean existingTransaction) throws HibernateException {
        if (this.getFlushMode() == 2 || !existingTransaction && this.getFlushMode() != 0) {
            this.logger.debug((Object)"Eagerly flushing Hibernate session");
            session.flush();
        }
    }

    public DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return this.convertJdbcAccessException((JDBCException)((Object)ex));
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(JDBCException ex) {
        return this.getJdbcExceptionTranslator().translate("Hibernate operation: " + ex.getMessage(), null, ex.getSQLException());
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        return this.getJdbcExceptionTranslator().translate("Hibernate operation", null, ex);
    }
}

