/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";
    private boolean singleSession = true;
    static /* synthetic */ Class class$net$sf$hibernate$SessionFactory;

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionFactory sessionFactory = this.lookupSessionFactory(request);
        boolean participate = false;
        if (this.isSingleSession()) {
            if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
                participate = true;
            } else {
                this.logger.debug((Object)"Opening single Hibernate Session in OpenSessionInViewFilter");
                Session session = this.getSession(sessionFactory);
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)new SessionHolder(session)));
            }
        } else if (SessionFactoryUtils.isDeferredCloseActive(sessionFactory)) {
            participate = true;
        } else {
            SessionFactoryUtils.initDeferredClose(sessionFactory);
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!participate) {
                if (this.isSingleSession()) {
                    SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)sessionFactory));
                    this.logger.debug((Object)"Closing single Hibernate Session in OpenSessionInViewFilter");
                    this.closeSession(sessionHolder.getSession(), sessionFactory);
                } else {
                    SessionFactoryUtils.processDeferredClose(sessionFactory);
                }
            }
        }
    }

    protected SessionFactory lookupSessionFactory(HttpServletRequest request) {
        return this.lookupSessionFactory();
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using SessionFactory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName(), class$net$sf$hibernate$SessionFactory == null ? (class$net$sf$hibernate$SessionFactory = OpenSessionInViewFilter.class$("net.sf.hibernate.SessionFactory")) : class$net$sf$hibernate$SessionFactory);
    }

    protected Session getSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        return this.openSession(sessionFactory);
    }

    protected Session openSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession(sessionFactory, true);
        session.setFlushMode(FlushMode.NEVER);
        return session;
    }

    protected void closeSession(Session session, SessionFactory sessionFactory) {
        SessionFactoryUtils.closeSession(session);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

