/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class Indexer
extends SpelNodeImpl {
    public Indexer(int pos, SpelNodeImpl expr) {
        super(pos, expr);
    }

    /*
     * Unable to fully structure code
     */
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        block22: {
            block19: {
                block20: {
                    block21: {
                        context = state.getActiveContextObject();
                        targetObject = context.getValue();
                        targetObjectTypeDescriptor = context.getTypeDescriptor();
                        indexValue = null;
                        index = null;
                        if (targetObject instanceof Map && this.children[0] instanceof PropertyOrFieldReference) {
                            reference = (PropertyOrFieldReference)this.children[0];
                            index = reference.getName();
                            indexValue = new TypedValue(index, TypeDescriptor.valueOf(String.class));
                        } else {
                            try {
                                state.pushActiveContextObject(state.getRootContextObject());
                                indexValue = this.children[0].getValueInternal(state);
                                index = indexValue.getValue();
                            }
                            finally {
                                state.popActiveContextObject();
                            }
                        }
                        if (targetObjectTypeDescriptor.isMap()) {
                            if (targetObject == null) {
                                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
                            }
                            possiblyConvertedKey = index;
                            if (targetObjectTypeDescriptor.isMapEntryTypeKnown()) {
                                possiblyConvertedKey = state.convertValue(index, TypeDescriptor.valueOf((Class)targetObjectTypeDescriptor.getMapKeyType()));
                            }
                            o = ((Map)targetObject).get(possiblyConvertedKey);
                            resultDescriptor = targetObjectTypeDescriptor.isMapEntryTypeKnown() != false ? TypeDescriptor.valueOf((Class)targetObjectTypeDescriptor.getMapValueType()) : TypeDescriptor.valueOf(Object.class);
                            return new TypedValue(o, resultDescriptor);
                        }
                        idx = (Integer)state.convertValue(index, Indexer.INTEGER_TYPE_DESCRIPTOR);
                        if (targetObject == null) {
                            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
                        }
                        if (targetObject.getClass().isArray()) {
                            return new TypedValue(this.accessArrayElement(targetObject, idx), TypeDescriptor.valueOf((Class)targetObjectTypeDescriptor.getElementType()));
                        }
                        if (!(targetObject instanceof Collection)) break block19;
                        c = (Collection)targetObject;
                        if (idx < c.size()) break block20;
                        if (!state.configuredToGrowCollection()) break block21;
                        newCollectionElement = null;
                        try {
                            newElements = idx - c.size();
                            elementClass = targetObjectTypeDescriptor.getElementType();
                            if (elementClass != null) ** GOTO lbl47
                            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.UNABLE_TO_GROW_COLLECTION_UNKNOWN_ELEMENT_TYPE, new Object[0]);
lbl-1000:
                            // 1 sources

                            {
                                c.add(elementClass.newInstance());
                                --newElements;
lbl47:
                                // 2 sources

                                ** while (newElements > 0)
                            }
lbl48:
                            // 1 sources

                            newCollectionElement = (E)targetObjectTypeDescriptor.getElementType().newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)e, SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)e, SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
                        }
                        c.add(newCollectionElement);
                        return new TypedValue(newCollectionElement, TypeDescriptor.valueOf((Class)targetObjectTypeDescriptor.getElementType()));
                    }
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, new Object[]{c.size(), idx});
                }
                pos = 0;
                for (E o : c) {
                    if (pos == idx) {
                        return new TypedValue(o, TypeDescriptor.valueOf((Class)targetObjectTypeDescriptor.getElementType()));
                    }
                    ++pos;
                }
                break block22;
            }
            if (targetObject instanceof String) {
                ctxString = (String)targetObject;
                if (idx >= ctxString.length()) {
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.STRING_INDEX_OUT_OF_BOUNDS, new Object[]{ctxString.length(), idx});
                }
                return new TypedValue(String.valueOf(ctxString.charAt(idx)), Indexer.STRING_TYPE_DESCRIPTOR);
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, new Object[]{targetObjectTypeDescriptor.asString()});
    }

    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(ExpressionState state, Object newValue) throws EvaluationException {
        TypedValue contextObject = state.getActiveContextObject();
        Object targetObject = contextObject.getValue();
        TypeDescriptor targetObjectTypeDescriptor = contextObject.getTypeDescriptor();
        TypedValue index = this.children[0].getValueInternal(state);
        if (targetObject == null) {
            throw new SpelEvaluationException(SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
        }
        if (targetObjectTypeDescriptor.isMap()) {
            Map map = (Map)targetObject;
            Object possiblyConvertedKey = index;
            Object possiblyConvertedValue = newValue;
            if (targetObjectTypeDescriptor.isMapEntryTypeKnown()) {
                possiblyConvertedKey = state.convertValue(index.getValue(), TypeDescriptor.valueOf((Class)targetObjectTypeDescriptor.getMapKeyType()));
                possiblyConvertedValue = state.convertValue(newValue, TypeDescriptor.valueOf((Class)targetObjectTypeDescriptor.getMapValueType()));
            }
            map.put(possiblyConvertedKey, possiblyConvertedValue);
            return;
        }
        if (targetObjectTypeDescriptor.isArray()) {
            int idx = (Integer)state.convertValue(index, INTEGER_TYPE_DESCRIPTOR);
            this.setArrayElement(state, contextObject.getValue(), idx, newValue, targetObjectTypeDescriptor.getElementType());
            return;
        } else {
            Collection c;
            if (!targetObjectTypeDescriptor.isCollection()) throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, contextObject.getClass().getName());
            int idx = (Integer)state.convertValue(index, INTEGER_TYPE_DESCRIPTOR);
            if (idx >= (c = (Collection)targetObject).size()) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, c.size(), idx);
            }
            if (!(targetObject instanceof List)) throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, contextObject.getClass().getName());
            List list = (List)targetObject;
            Object possiblyConvertedValue = state.convertValue(newValue, TypeDescriptor.valueOf((Class)targetObjectTypeDescriptor.getElementType()));
            list.set(idx, possiblyConvertedValue);
        }
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < this.getChildCount()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private void setArrayElement(ExpressionState state, Object ctx, int idx, Object newValue, Class clazz) throws EvaluationException {
        Class arrayComponentType = clazz;
        if (arrayComponentType == Integer.TYPE) {
            int[] array = (int[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Integer)state.convertValue(newValue, INTEGER_TYPE_DESCRIPTOR);
        } else if (arrayComponentType == Boolean.TYPE) {
            boolean[] array = (boolean[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Boolean)state.convertValue(newValue, BOOLEAN_TYPE_DESCRIPTOR);
        } else if (arrayComponentType == Character.TYPE) {
            char[] array = (char[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = ((Character)state.convertValue(newValue, CHARACTER_TYPE_DESCRIPTOR)).charValue();
        } else if (arrayComponentType == Long.TYPE) {
            long[] array = (long[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Long)state.convertValue(newValue, LONG_TYPE_DESCRIPTOR);
        } else if (arrayComponentType == Short.TYPE) {
            short[] array = (short[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Short)state.convertValue(newValue, SHORT_TYPE_DESCRIPTOR);
        } else if (arrayComponentType == Double.TYPE) {
            double[] array = (double[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Double)state.convertValue(newValue, DOUBLE_TYPE_DESCRIPTOR);
        } else if (arrayComponentType == Float.TYPE) {
            float[] array = (float[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = ((Float)state.convertValue(newValue, FLOAT_TYPE_DESCRIPTOR)).floatValue();
        } else if (arrayComponentType == Byte.TYPE) {
            byte[] array = (byte[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = (Byte)state.convertValue(newValue, BYTE_TYPE_DESCRIPTOR);
        } else {
            Object[] array = (Object[])ctx;
            this.checkAccess(array.length, idx);
            array[idx] = state.convertValue(newValue, TypeDescriptor.valueOf((Class)clazz));
        }
    }

    private Object accessArrayElement(Object ctx, int idx) throws SpelEvaluationException {
        Class<?> arrayComponentType = ctx.getClass().getComponentType();
        if (arrayComponentType == Integer.TYPE) {
            int[] array = (int[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Boolean.TYPE) {
            boolean[] array = (boolean[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Character.TYPE) {
            char[] array = (char[])ctx;
            this.checkAccess(array.length, idx);
            return Character.valueOf(array[idx]);
        }
        if (arrayComponentType == Long.TYPE) {
            long[] array = (long[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Short.TYPE) {
            short[] array = (short[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Double.TYPE) {
            double[] array = (double[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        if (arrayComponentType == Float.TYPE) {
            float[] array = (float[])ctx;
            this.checkAccess(array.length, idx);
            return Float.valueOf(array[idx]);
        }
        if (arrayComponentType == Byte.TYPE) {
            byte[] array = (byte[])ctx;
            this.checkAccess(array.length, idx);
            return array[idx];
        }
        Object[] array = (Object[])ctx;
        this.checkAccess(array.length, idx);
        return array[idx];
    }

    private void checkAccess(int arrayLength, int index) throws SpelEvaluationException {
        if (index > arrayLength) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.ARRAY_INDEX_OUT_OF_BOUNDS, arrayLength, index);
        }
    }
}

