/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class Projection
extends SpelNodeImpl {
    private final boolean nullSafe;

    public Projection(boolean nullSafe, int pos, SpelNodeImpl expression) {
        super(pos, expression);
        this.nullSafe = nullSafe;
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue op = state.getActiveContextObject();
        Object operand = op.getValue();
        if (operand instanceof Map) {
            Map mapdata = (Map)operand;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Map.Entry entry : mapdata.entrySet()) {
                try {
                    state.pushActiveContextObject(new TypedValue(entry, TypeDescriptor.valueOf(Map.Entry.class)));
                    result.add(this.children[0].getValueInternal(state).getValue());
                }
                finally {
                    state.popActiveContextObject();
                }
            }
            return new TypedValue(result, TypeDescriptor.valueOf(List.class));
        }
        if (operand instanceof List) {
            ArrayList data = new ArrayList();
            data.addAll((Collection)operand);
            ArrayList<Object> result = new ArrayList<Object>();
            int idx = 0;
            for (Object element : data) {
                try {
                    state.pushActiveContextObject(new TypedValue(element, TypeDescriptor.valueOf((Class)op.getTypeDescriptor().getType())));
                    state.enterScope("index", idx);
                    result.add(this.children[0].getValueInternal(state).getValue());
                }
                finally {
                    state.exitScope();
                    state.popActiveContextObject();
                }
                ++idx;
            }
            return new TypedValue(result, op.getTypeDescriptor());
        }
        if (operand == null) {
            if (this.nullSafe) {
                return TypedValue.NULL_TYPED_VALUE;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, operand.getClass().getName());
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        return sb.append("![").append(this.getChild(0).toStringAST()).append("]").toString();
    }
}

