/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.common.ExpressionUtils;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpelExpression
implements Expression {
    private final String expression;
    public final SpelNodeImpl ast;
    public final int configuration;

    public SpelExpression(String expression, SpelNodeImpl ast, int configuration) {
        this.expression = expression;
        this.ast = ast;
        this.configuration = configuration;
    }

    @Override
    public Object getValue() throws EvaluationException {
        ExpressionState expressionState = new ExpressionState(new StandardEvaluationContext(), this.configuration);
        return this.ast.getValue(expressionState);
    }

    @Override
    public <T> T getValue(Class<T> expectedResultType) throws EvaluationException {
        ExpressionState expressionState = new ExpressionState(new StandardEvaluationContext(), this.configuration);
        Object result = this.ast.getValue(expressionState);
        return ExpressionUtils.convert(expressionState.getEvaluationContext(), result, expectedResultType);
    }

    @Override
    public Object getValue(EvaluationContext context) throws EvaluationException {
        Assert.notNull((Object)context, (String)"The EvaluationContext is required");
        return this.ast.getValue(new ExpressionState(context, this.configuration));
    }

    @Override
    public <T> T getValue(EvaluationContext context, Class<T> expectedResultType) throws EvaluationException {
        Class<?> resultType;
        Object result = this.ast.getValue(new ExpressionState(context, this.configuration));
        if (result != null && expectedResultType != null && !expectedResultType.isAssignableFrom(resultType = result.getClass())) {
            result = context.getTypeConverter().convertValue(result, TypeDescriptor.valueOf(expectedResultType));
        }
        return (T)result;
    }

    @Override
    public Class getValueType() throws EvaluationException {
        return this.ast.getValueInternal(new ExpressionState(new StandardEvaluationContext(), this.configuration)).getTypeDescriptor().getType();
    }

    @Override
    public Class getValueType(EvaluationContext context) throws EvaluationException {
        Assert.notNull((Object)context, (String)"The EvaluationContext is required");
        ExpressionState eState = new ExpressionState(context, this.configuration);
        TypeDescriptor typeDescriptor = this.ast.getValueInternal(eState).getTypeDescriptor();
        return typeDescriptor.getType();
    }

    @Override
    public TypeDescriptor getValueTypeDescriptor() throws EvaluationException {
        return this.ast.getValueInternal(new ExpressionState(new StandardEvaluationContext(), this.configuration)).getTypeDescriptor();
    }

    @Override
    public TypeDescriptor getValueTypeDescriptor(EvaluationContext context) throws EvaluationException {
        Assert.notNull((Object)context, (String)"The EvaluationContext is required");
        ExpressionState eState = new ExpressionState(context, this.configuration);
        return this.ast.getValueInternal(eState).getTypeDescriptor();
    }

    @Override
    public String getExpressionString() {
        return this.expression;
    }

    @Override
    public boolean isWritable(EvaluationContext context) throws EvaluationException {
        Assert.notNull((Object)context, (String)"The EvaluationContext is required");
        return this.ast.isWritable(new ExpressionState(context, this.configuration));
    }

    @Override
    public void setValue(EvaluationContext context, Object value) throws EvaluationException {
        Assert.notNull((Object)context, (String)"The EvaluationContext is required");
        this.ast.setValue(new ExpressionState(context, this.configuration), value);
    }

    public SpelNode getAST() {
        return this.ast;
    }

    public String toStringAST() {
        return this.ast.toStringAST();
    }
}

