/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

public class TransactionAttributeSourceAdvisor
extends AbstractPointcutAdvisor {
    private final TransactionAttributeSourcePointcut pointcut = new TransactionAttributeSourcePointcut();

    public TransactionAttributeSourceAdvisor() {
    }

    public TransactionAttributeSourceAdvisor(TransactionInterceptor interceptor) {
        this.setTransactionInterceptor(interceptor);
    }

    public void setTransactionInterceptor(TransactionInterceptor interceptor) {
        this.setAdvice((Advice)interceptor);
        if (interceptor.getTransactionAttributeSource() == null) {
            throw new AopConfigException("Cannot construct a TransactionAttributeSourceAdvisor using a TransactionInterceptor that has no TransactionAttributeSource configured");
        }
        this.pointcut.setTransactionAttributeSource(interceptor.getTransactionAttributeSource());
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void setClassFilter(ClassFilter classFilter) {
        this.pointcut.setClassFilter(classFilter);
    }

    public static class TransactionAttributeSourcePointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        private TransactionAttributeSource transactionAttributeSource;

        public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
            this.transactionAttributeSource = transactionAttributeSource;
        }

        public boolean matches(Method method, Class targetClass) {
            Assert.notNull((Object)this.transactionAttributeSource, (String)"transactionAttributeSource is required");
            return this.transactionAttributeSource.getTransactionAttribute(method, targetClass) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionAttributeSourcePointcut that = (TransactionAttributeSourcePointcut)o;
            return !(this.transactionAttributeSource != null ? !this.transactionAttributeSource.equals(that.transactionAttributeSource) : that.transactionAttributeSource != null);
        }

        public int hashCode() {
            return this.transactionAttributeSource != null ? this.transactionAttributeSource.hashCode() : 0;
        }
    }
}

