/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.method;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.method.DefaultMethodValidationResult;
import org.springframework.validation.method.EmptyMethodValidationResult;
import org.springframework.validation.method.ParameterErrors;
import org.springframework.validation.method.ParameterValidationResult;

public interface MethodValidationResult {
    public Object getTarget();

    public Method getMethod();

    public boolean isForReturnValue();

    default public boolean hasErrors() {
        return !this.getAllValidationResults().isEmpty();
    }

    default public List<? extends MessageSourceResolvable> getAllErrors() {
        return this.getAllValidationResults().stream().flatMap(result -> result.getResolvableErrors().stream()).toList();
    }

    public List<ParameterValidationResult> getAllValidationResults();

    default public List<ParameterValidationResult> getValueResults() {
        return this.getAllValidationResults().stream().filter(result -> !(result instanceof ParameterErrors)).toList();
    }

    default public List<ParameterErrors> getBeanResults() {
        return this.getAllValidationResults().stream().filter(ParameterErrors.class::isInstance).map(result -> (ParameterErrors)result).toList();
    }

    public static MethodValidationResult create(Object target, Method method, List<ParameterValidationResult> results) {
        return new DefaultMethodValidationResult(target, method, results);
    }

    public static MethodValidationResult emptyResult() {
        return new EmptyMethodValidationResult();
    }
}

