/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;

class GeneratedClassHandler
implements BiConsumer<String, byte[]> {
    private static final Consumer<TypeHint.Builder> asCglibProxy = hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS});
    private static final Consumer<TypeHint.Builder> asCglibProxyTargetType = hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS});
    private final RuntimeHints runtimeHints;
    private final GeneratedFiles generatedFiles;

    GeneratedClassHandler(GenerationContext generationContext) {
        this.runtimeHints = generationContext.getRuntimeHints();
        this.generatedFiles = generationContext.getGeneratedFiles();
    }

    @Override
    public void accept(String className, byte[] content) {
        this.runtimeHints.reflection().registerType(TypeReference.of((String)className), asCglibProxy).registerType(TypeReference.of((String)this.getTargetTypeClassName(className)), asCglibProxyTargetType);
        String path = className.replace(".", "/") + ".class";
        this.generatedFiles.addFile(GeneratedFiles.Kind.CLASS, path, (InputStreamSource)new ByteArrayResource(content));
    }

    private String getTargetTypeClassName(String proxyClassName) {
        int index = proxyClassName.indexOf("$$SpringCGLIB$$");
        if (index == -1) {
            throw new IllegalArgumentException("Failed to extract target type from " + proxyClassName);
        }
        return proxyClassName.substring(0, index);
    }
}

