/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class ApplicationContextAotInitializer {
    private static final Log logger = LogFactory.getLog(ApplicationContextAotInitializer.class);

    public void initialize(ConfigurableApplicationContext context, String ... initializerClassNames) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing ApplicationContext with AOT");
        }
        for (String initializerClassName : initializerClassNames) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Applying " + initializerClassName));
            }
            this.loadInitializer(initializerClassName, context.getClassLoader()).initialize(context);
        }
    }

    private ApplicationContextInitializer<ConfigurableApplicationContext> loadInitializer(String className, @Nullable ClassLoader classLoader) {
        Object initializer = ApplicationContextAotInitializer.instantiate(className, classLoader);
        if (!(initializer instanceof ApplicationContextInitializer)) {
            throw new IllegalArgumentException("Not an ApplicationContextInitializer: " + className);
        }
        return (ApplicationContextInitializer)initializer;
    }

    private static Object instantiate(String className, @Nullable ClassLoader classLoader) {
        try {
            Class type = ClassUtils.forName((String)className, (ClassLoader)classLoader);
            return BeanUtils.instantiateClass((Class)type);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to instantiate ApplicationContextInitializer: " + className, ex);
        }
    }
}

