/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.context.aot.ApplicationContextInitializationCodeGenerator;
import org.springframework.context.aot.BeanFactoryInitializationAotContributions;
import org.springframework.context.aot.GeneratedClassHandler;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.javapoet.ClassName;

public class ApplicationContextAotGenerator {
    public ClassName processAheadOfTime(GenericApplicationContext applicationContext, GenerationContext generationContext) {
        return this.withGeneratedClassHandler(new GeneratedClassHandler(generationContext), () -> {
            applicationContext.refreshForAotProcessing(generationContext.getRuntimeHints());
            DefaultListableBeanFactory beanFactory = applicationContext.getDefaultListableBeanFactory();
            ApplicationContextInitializationCodeGenerator codeGenerator = new ApplicationContextInitializationCodeGenerator(generationContext);
            new BeanFactoryInitializationAotContributions(beanFactory).applyTo(generationContext, codeGenerator);
            return codeGenerator.getGeneratedClass().getName();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withGeneratedClassHandler(GeneratedClassHandler generatedClassHandler, Supplier<T> task) {
        try {
            ReflectUtils.setGeneratedClassHandler((BiConsumer)generatedClassHandler);
            T t = task.get();
            return t;
        }
        finally {
            ReflectUtils.setGeneratedClassHandler(null);
        }
    }
}

