/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.time.Clock;
import java.time.Instant;
import java.util.Date;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TriggerContext;

public class SimpleTriggerContext
implements TriggerContext {
    private final Clock clock;
    @Nullable
    private volatile Instant lastScheduledExecution;
    @Nullable
    private volatile Instant lastActualExecution;
    @Nullable
    private volatile Instant lastCompletion;

    public SimpleTriggerContext() {
        this.clock = Clock.systemDefaultZone();
    }

    @Deprecated
    public SimpleTriggerContext(@Nullable Date lastScheduledExecutionTime, @Nullable Date lastActualExecutionTime, @Nullable Date lastCompletionTime) {
        this(SimpleTriggerContext.toInstant(lastScheduledExecutionTime), SimpleTriggerContext.toInstant(lastActualExecutionTime), SimpleTriggerContext.toInstant(lastCompletionTime));
    }

    @Nullable
    private static Instant toInstant(@Nullable Date date) {
        return date != null ? date.toInstant() : null;
    }

    public SimpleTriggerContext(@Nullable Instant lastScheduledExecution, @Nullable Instant lastActualExecution, @Nullable Instant lastCompletion) {
        this();
        this.lastScheduledExecution = lastScheduledExecution;
        this.lastActualExecution = lastActualExecution;
        this.lastCompletion = lastCompletion;
    }

    public SimpleTriggerContext(Clock clock) {
        this.clock = clock;
    }

    @Deprecated
    public void update(@Nullable Date lastScheduledExecutionTime, @Nullable Date lastActualExecutionTime, @Nullable Date lastCompletionTime) {
        this.update(SimpleTriggerContext.toInstant(lastScheduledExecutionTime), SimpleTriggerContext.toInstant(lastActualExecutionTime), SimpleTriggerContext.toInstant(lastCompletionTime));
    }

    public void update(@Nullable Instant lastScheduledExecution, @Nullable Instant lastActualExecution, @Nullable Instant lastCompletion) {
        this.lastScheduledExecution = lastScheduledExecution;
        this.lastActualExecution = lastActualExecution;
        this.lastCompletion = lastCompletion;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    @Nullable
    public Instant lastScheduledExecution() {
        return this.lastScheduledExecution;
    }

    @Override
    @Nullable
    public Instant lastActualExecution() {
        return this.lastActualExecution;
    }

    @Override
    @Nullable
    public Instant lastCompletion() {
        return this.lastCompletion;
    }
}

