/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.annotation.Reflective;
import org.springframework.aot.hint.annotation.ReflectiveProcessor;
import org.springframework.aot.hint.support.RuntimeHintsUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class ReflectiveProcessorBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private final Map<Class<? extends ReflectiveProcessor>, ReflectiveProcessor> processors = new HashMap<Class<? extends ReflectiveProcessor>, ReflectiveProcessor>();

    ReflectiveProcessorBeanRegistrationAotProcessor() {
    }

    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        LinkedHashSet<Entry> entries = new LinkedHashSet<Entry>();
        this.processType(entries, beanClass);
        for (Class implementedInterface : ClassUtils.getAllInterfacesForClass((Class)beanClass)) {
            this.processType(entries, implementedInterface);
        }
        if (!entries.isEmpty()) {
            return new ReflectiveProcessorBeanRegistrationAotContribution(entries);
        }
        return null;
    }

    private void processType(Set<Entry> entries, Class<?> typeToProcess) {
        if (this.isReflective(typeToProcess)) {
            entries.add(this.createEntry(typeToProcess));
        }
        this.doWithReflectiveConstructors(typeToProcess, constructor -> entries.add(this.createEntry((AnnotatedElement)constructor)));
        ReflectionUtils.doWithFields(typeToProcess, field -> entries.add(this.createEntry(field)), this::isReflective);
        ReflectionUtils.doWithMethods(typeToProcess, method -> entries.add(this.createEntry(method)), this::isReflective);
    }

    private void doWithReflectiveConstructors(Class<?> typeToProcess, Consumer<Constructor<?>> consumer) {
        for (Constructor<?> constructor : typeToProcess.getDeclaredConstructors()) {
            if (!this.isReflective(constructor)) continue;
            consumer.accept(constructor);
        }
    }

    private boolean isReflective(AnnotatedElement element) {
        return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Reflective.class);
    }

    private Entry createEntry(AnnotatedElement element) {
        Class[] processorClasses = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(Reflective.class).getClassArray("value");
        List<ReflectiveProcessor> processors = Arrays.stream(processorClasses).distinct().map(processorClass -> this.processors.computeIfAbsent((Class<? extends ReflectiveProcessor>)processorClass, BeanUtils::instantiateClass)).toList();
        DelegateReflectiveProcessor processorToUse = processors.size() == 1 ? processors.get(0) : new DelegateReflectiveProcessor(processors);
        return new Entry(element, processorToUse);
    }

    private static class ReflectiveProcessorBeanRegistrationAotContribution
    implements BeanRegistrationAotContribution {
        private final Iterable<Entry> entries;

        public ReflectiveProcessorBeanRegistrationAotContribution(Iterable<Entry> entries) {
            this.entries = entries;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            RuntimeHints runtimeHints = generationContext.getRuntimeHints();
            this.entries.forEach(entry -> {
                AnnotatedElement element = entry.element();
                entry.processor().registerReflectionHints(runtimeHints.reflection(), element);
                this.registerAnnotationIfNecessary(runtimeHints, element);
            });
        }

        private void registerAnnotationIfNecessary(RuntimeHints hints, AnnotatedElement element) {
            MergedAnnotation reflectiveAnnotation = MergedAnnotations.from((AnnotatedElement)element).get(Reflective.class);
            if (reflectiveAnnotation.getDistance() > 0) {
                RuntimeHintsUtils.registerAnnotation((RuntimeHints)hints, (Class)reflectiveAnnotation.getRoot().getType());
            }
        }
    }

    private record Entry(AnnotatedElement element, ReflectiveProcessor processor) {
    }

    static class DelegateReflectiveProcessor
    implements ReflectiveProcessor {
        private final Iterable<ReflectiveProcessor> processors;

        public DelegateReflectiveProcessor(Iterable<ReflectiveProcessor> processors) {
            this.processors = processors;
        }

        public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
            this.processors.forEach(processor -> processor.registerReflectionHints(hints, element));
        }
    }
}

