/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.hint.ExecutableHint;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.TypeHint;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class BindingReflectionHintsRegistrar {
    private static final Log logger = LogFactory.getLog(BindingReflectionHintsRegistrar.class);
    private static final Consumer<ExecutableHint.Builder> INVOKE = builder -> builder.withMode(ExecutableMode.INVOKE);
    private static final String KOTLIN_COMPANION_SUFFIX = "$Companion";

    public void registerReflectionHints(ReflectionHints hints, Type ... types) {
        LinkedHashSet<Type> seen = new LinkedHashSet<Type>();
        for (Type type : types) {
            this.registerReflectionHints(hints, seen, type);
        }
    }

    protected boolean shouldRegisterMembers(Class<?> type) {
        return !type.getCanonicalName().startsWith("java.") && !type.isArray();
    }

    private void registerReflectionHints(ReflectionHints hints, Set<Type> seen, Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isPrimitive() || clazz == Object.class) {
                return;
            }
            hints.registerType(clazz, arg_0 -> this.lambda$registerReflectionHints$1(seen, type, clazz, hints, arg_0));
        }
        LinkedHashSet referencedTypes = new LinkedHashSet();
        this.collectReferencedTypes(seen, referencedTypes, type);
        referencedTypes.forEach(referencedType -> this.registerReflectionHints(hints, seen, (Type)referencedType));
    }

    private void registerRecordHints(ReflectionHints hints, Set<Type> seen, Method method) {
        hints.registerMethod(method, INVOKE);
        MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)-1);
        Type methodParameterType = methodParameter.getGenericParameterType();
        if (!seen.contains(methodParameterType)) {
            this.registerReflectionHints(hints, seen, methodParameterType);
        }
    }

    private void registerPropertyHints(ReflectionHints hints, Set<Type> seen, @Nullable Method method, int parameterIndex) {
        if (method != null && method.getDeclaringClass() != Object.class && method.getDeclaringClass() != Enum.class) {
            hints.registerMethod(method, INVOKE);
            MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)parameterIndex);
            Type methodParameterType = methodParameter.getGenericParameterType();
            if (!seen.contains(methodParameterType)) {
                this.registerReflectionHints(hints, seen, methodParameterType);
            }
        }
    }

    private void registerKotlinSerializationHints(ReflectionHints hints, Class<?> clazz) {
        Class companionClass;
        Method serializerMethod;
        String companionClassName = clazz.getCanonicalName() + KOTLIN_COMPANION_SUFFIX;
        if (ClassUtils.isPresent((String)companionClassName, null) && (serializerMethod = ClassUtils.getMethodIfAvailable((Class)(companionClass = ClassUtils.resolveClassName((String)companionClassName, null)), (String)"serializer", (Class[])new Class[0])) != null) {
            hints.registerMethod(serializerMethod);
        }
    }

    private void collectReferencedTypes(Set<Type> seen, Set<Class<?>> types, Type type) {
        if (seen.contains(type)) {
            return;
        }
        ResolvableType resolvableType = ResolvableType.forType((Type)type);
        Class clazz = resolvableType.resolve();
        if (clazz != null && !types.contains(clazz)) {
            types.add(clazz);
            for (ResolvableType genericResolvableType : resolvableType.getGenerics()) {
                this.collectReferencedTypes(seen, types, genericResolvableType.getType());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$registerReflectionHints$1(Set seen, Type type, Class clazz, ReflectionHints hints, TypeHint.Builder builder) {
        if (seen.contains(type)) {
            return;
        }
        seen.add(type);
        if (this.shouldRegisterMembers(clazz)) {
            if (clazz.isRecord()) {
                builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                for (RecordComponent recordComponent : clazz.getRecordComponents()) {
                    this.registerRecordHints(hints, seen, recordComponent.getAccessor());
                }
            } else {
                builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                try {
                    beanInfo = Introspector.getBeanInfo(clazz);
                    for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                        this.registerPropertyHints(hints, seen, propertyDescriptor.getWriteMethod(), 0);
                        this.registerPropertyHints(hints, seen, propertyDescriptor.getReadMethod(), -1);
                    }
                }
                catch (IntrospectionException ex) {
                    if (!BindingReflectionHintsRegistrar.logger.isDebugEnabled()) ** GOTO lbl25
                    BindingReflectionHintsRegistrar.logger.debug((Object)("Ignoring referenced type [" + clazz.getName() + "]: " + ex.getMessage()));
                }
            }
        }
lbl25:
        // 6 sources

        if (KotlinDetector.isKotlinType((Class)clazz)) {
            this.registerKotlinSerializationHints(hints, clazz);
        }
    }
}

