/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.asm.Type;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;
import org.springframework.cglib.core.ClassGenerator;
import org.springframework.cglib.core.DefaultGeneratorStrategy;
import org.springframework.cglib.core.GeneratorStrategy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.cglib.proxy.NoOp;
import org.springframework.cglib.transform.ClassEmitterTransformer;
import org.springframework.cglib.transform.ClassTransformer;
import org.springframework.cglib.transform.TransformingClassGenerator;
import org.springframework.context.annotation.BeanAnnotationHelper;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyCreator;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class ConfigurationClassEnhancer {
    private static final Log logger = LogFactory.getLog(ConfigurationClassEnhancer.class);
    private static final Callback[] CALLBACKS = new Callback[]{new BeanMethodInterceptor(), new DisposableBeanMethodInterceptor(), new BeanFactoryAwareMethodInterceptor(), NoOp.INSTANCE};
    private static final ConditionalCallbackFilter CALLBACK_FILTER = new ConditionalCallbackFilter(CALLBACKS);
    private static final String BEAN_FACTORY_FIELD = "$$beanFactory";

    ConfigurationClassEnhancer() {
    }

    public Class<?> enhance(Class<?> configClass) {
        if (EnhancedConfiguration.class.isAssignableFrom(configClass)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Ignoring request to enhance %s as it has already been enhanced. This usually indicates that more than one ConfigurationClassPostProcessor has been registered (e.g. via <context:annotation-config>). This is harmless, but you may want check your configuration and remove one CCPP if possible", configClass.getName()));
            }
            return configClass;
        }
        Class<?> enhancedClass = this.createClass(this.newEnhancer(configClass));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Successfully enhanced %s; enhanced class name is: %s", configClass.getName(), enhancedClass.getName()));
        }
        return enhancedClass;
    }

    private Enhancer newEnhancer(Class<?> superclass) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(superclass);
        enhancer.setInterfaces(new Class[]{EnhancedConfiguration.class});
        enhancer.setUseFactory(false);
        enhancer.setCallbackFilter((CallbackFilter)CALLBACK_FILTER);
        enhancer.setCallbackTypes((Class[])CALLBACK_FILTER.getCallbackTypes());
        enhancer.setStrategy((GeneratorStrategy)new DefaultGeneratorStrategy(){

            protected ClassGenerator transform(ClassGenerator cg) throws Exception {
                ClassEmitterTransformer transformer = new ClassEmitterTransformer(){

                    public void end_class() {
                        this.declare_field(1, ConfigurationClassEnhancer.BEAN_FACTORY_FIELD, Type.getType(BeanFactory.class), null);
                        super.end_class();
                    }
                };
                return new TransformingClassGenerator(cg, (ClassTransformer)transformer);
            }
        });
        return enhancer;
    }

    private Class<?> createClass(Enhancer enhancer) {
        Class subclass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)subclass, (Callback[])CALLBACKS);
        return subclass;
    }

    private static class BeanMethodInterceptor
    implements MethodInterceptor,
    ConditionalCallback {
        private BeanMethodInterceptor() {
        }

        @Override
        public boolean isMatch(Method candidateMethod) {
            return BeanAnnotationHelper.isBeanAnnotated(candidateMethod);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object enhancedConfigInstance, Method beanMethod, Object[] beanMethodArgs, MethodProxy cglibMethodProxy) throws Throwable {
            Object factoryBean;
            String scopedBeanName;
            ConfigurableBeanFactory beanFactory = this.getBeanFactory(enhancedConfigInstance);
            String beanName = BeanAnnotationHelper.determineBeanNameFor(beanMethod);
            Scope scope = (Scope)AnnotationUtils.findAnnotation((Method)beanMethod, Scope.class);
            if (scope != null && scope.proxyMode() != ScopedProxyMode.NO && beanFactory.isCurrentlyInCreation(scopedBeanName = ScopedProxyCreator.getTargetBeanName(beanName))) {
                beanName = scopedBeanName;
            }
            if (this.factoryContainsBean(beanFactory, "&" + beanName) && this.factoryContainsBean(beanFactory, beanName) && !((factoryBean = beanFactory.getBean("&" + beanName)) instanceof ScopedProxyFactoryBean)) {
                return this.enhanceFactoryBean(factoryBean.getClass(), beanFactory, beanName);
            }
            if (this.isCurrentlyInvokedFactoryMethod(beanMethod) && !beanFactory.containsSingleton(beanName)) {
                if (BeanFactoryPostProcessor.class.isAssignableFrom(beanMethod.getReturnType())) {
                    logger.warn((Object)String.format("@Bean method %s.%s is non-static and returns an object assignable to Spring's BeanFactoryPostProcessor interface. This will result in a failure to process annotations such as @Autowired, @Resource and @PostConstruct within the method's declaring @Configuration class. Add the 'static' modifier to this method to avoid these container lifecycle issues; see @Bean Javadoc for complete details", beanMethod.getDeclaringClass().getSimpleName(), beanMethod.getName()));
                }
                return cglibMethodProxy.invokeSuper(enhancedConfigInstance, beanMethodArgs);
            }
            boolean alreadyInCreation = beanFactory.isCurrentlyInCreation(beanName);
            try {
                if (alreadyInCreation) {
                    beanFactory.setCurrentlyInCreation(beanName, false);
                }
                Object object = beanFactory.getBean(beanName);
                return object;
            }
            finally {
                if (alreadyInCreation) {
                    beanFactory.setCurrentlyInCreation(beanName, true);
                }
            }
        }

        private boolean factoryContainsBean(ConfigurableBeanFactory beanFactory, String beanName) {
            return beanFactory.containsBean(beanName) && !beanFactory.isCurrentlyInCreation(beanName);
        }

        private boolean isCurrentlyInvokedFactoryMethod(Method method) {
            Method currentlyInvoked = SimpleInstantiationStrategy.getCurrentlyInvokedFactoryMethod();
            return currentlyInvoked != null && method.getName().equals(currentlyInvoked.getName()) && Arrays.equals(method.getParameterTypes(), currentlyInvoked.getParameterTypes());
        }

        private Object enhanceFactoryBean(Class<?> fbClass, final ConfigurableBeanFactory beanFactory, final String beanName) throws InstantiationException, IllegalAccessException {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(fbClass);
            enhancer.setUseFactory(false);
            enhancer.setCallback((Callback)new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    if (method.getName().equals("getObject") && args.length == 0) {
                        return beanFactory.getBean(beanName);
                    }
                    return proxy.invokeSuper(obj, args);
                }
            });
            return enhancer.create();
        }

        private ConfigurableBeanFactory getBeanFactory(Object enhancedConfigInstance) {
            Field field = ReflectionUtils.findField(enhancedConfigInstance.getClass(), (String)ConfigurationClassEnhancer.BEAN_FACTORY_FIELD);
            Assert.state((field != null ? 1 : 0) != 0, (String)"Unable to find generated bean factory field");
            Object beanFactory = ReflectionUtils.getField((Field)field, (Object)enhancedConfigInstance);
            Assert.state((beanFactory != null ? 1 : 0) != 0, (String)"The BeanFactory has not been injected into the @Configuration class");
            Assert.state((boolean)(beanFactory instanceof ConfigurableBeanFactory), (String)"The injected BeanFactory is not a ConfigurableBeanFactory");
            return (ConfigurableBeanFactory)beanFactory;
        }
    }

    private static class BeanFactoryAwareMethodInterceptor
    implements MethodInterceptor,
    ConditionalCallback {
        private BeanFactoryAwareMethodInterceptor() {
        }

        @Override
        public boolean isMatch(Method candidateMethod) {
            return candidateMethod.getName().equals("setBeanFactory") && candidateMethod.getParameterTypes().length == 1 && candidateMethod.getParameterTypes()[0].equals(BeanFactory.class) && BeanFactoryAware.class.isAssignableFrom(candidateMethod.getDeclaringClass());
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Field field = obj.getClass().getDeclaredField(ConfigurationClassEnhancer.BEAN_FACTORY_FIELD);
            Assert.state((field != null ? 1 : 0) != 0, (String)"Unable to find generated bean factory field");
            field.set(obj, args[0]);
            if (BeanFactoryAware.class.isAssignableFrom(obj.getClass().getSuperclass())) {
                return proxy.invokeSuper(obj, args);
            }
            return null;
        }
    }

    private static class DisposableBeanMethodInterceptor
    implements MethodInterceptor,
    ConditionalCallback {
        private DisposableBeanMethodInterceptor() {
        }

        @Override
        public boolean isMatch(Method candidateMethod) {
            return candidateMethod.getName().equals("destroy") && candidateMethod.getParameterTypes().length == 0 && DisposableBean.class.isAssignableFrom(candidateMethod.getDeclaringClass());
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Enhancer.registerStaticCallbacks(obj.getClass(), null);
            if (DisposableBean.class.isAssignableFrom(obj.getClass().getSuperclass())) {
                return proxy.invokeSuper(obj, args);
            }
            return null;
        }
    }

    private static class ConditionalCallbackFilter
    implements CallbackFilter {
        private final Callback[] callbacks;
        private final Class<?>[] callbackTypes;

        public ConditionalCallbackFilter(Callback[] callbacks) {
            this.callbacks = callbacks;
            this.callbackTypes = new Class[callbacks.length];
            for (int i = 0; i < callbacks.length; ++i) {
                this.callbackTypes[i] = callbacks[i].getClass();
            }
        }

        public int accept(Method method) {
            for (int i = 0; i < this.callbacks.length; ++i) {
                if (this.callbacks[i] instanceof ConditionalCallback && !((ConditionalCallback)this.callbacks[i]).isMatch(method)) continue;
                return i;
            }
            throw new IllegalStateException("No callback available for method " + method.getName());
        }

        public Class<?>[] getCallbackTypes() {
            return this.callbackTypes;
        }
    }

    private static interface ConditionalCallback
    extends Callback {
        public boolean isMatch(Method var1);
    }

    public static interface EnhancedConfiguration
    extends DisposableBean,
    BeanFactoryAware {
    }
}

