/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.cache.interceptor.CompositeCacheOperationSource;
import org.springframework.cache.interceptor.ExpressionEvaluator;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public abstract class CacheAspectSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ExpressionEvaluator evaluator = new ExpressionEvaluator();
    private CacheManager cacheManager;
    private CacheOperationSource cacheOperationSource;
    private KeyGenerator keyGenerator = new SimpleKeyGenerator();
    private boolean initialized = false;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheOperationSources(CacheOperationSource ... cacheOperationSources) {
        Assert.notEmpty((Object[])cacheOperationSources);
        this.cacheOperationSource = cacheOperationSources.length > 1 ? new CompositeCacheOperationSource(cacheOperationSources) : cacheOperationSources[0];
    }

    public CacheOperationSource getCacheOperationSource() {
        return this.cacheOperationSource;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void afterPropertiesSet() {
        Assert.state((this.cacheManager != null ? 1 : 0) != 0, (String)"'cacheManager' is required");
        Assert.state((this.cacheOperationSource != null ? 1 : 0) != 0, (String)"The 'cacheOperationSources' property is required: If there are no cacheable methods, then don't use a cache aspect.");
        this.initialized = true;
    }

    protected String methodIdentification(Method method, Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        return ClassUtils.getQualifiedMethodName((Method)specificMethod);
    }

    protected Collection<Cache> getCaches(CacheOperation operation) {
        Set<String> cacheNames = operation.getCacheNames();
        ArrayList<Cache> caches = new ArrayList<Cache>(cacheNames.size());
        for (String cacheName : cacheNames) {
            Cache cache = this.cacheManager.getCache(cacheName);
            Assert.notNull((Object)cache, (String)("Cannot find cache named '" + cacheName + "' for " + operation));
            caches.add(cache);
        }
        return caches;
    }

    protected CacheOperationContext getOperationContext(CacheOperation operation, Method method, Object[] args, Object target, Class<?> targetClass) {
        return new CacheOperationContext(operation, method, args, target, targetClass);
    }

    protected Object execute(Invoker invoker, Object target, Method method, Object[] args) {
        if (this.initialized) {
            Class<?> targetClass = this.getTargetClass(target);
            Collection<CacheOperation> operations = this.getCacheOperationSource().getCacheOperations(method, targetClass);
            if (!CollectionUtils.isEmpty(operations)) {
                return this.execute(invoker, new CacheOperationContexts(operations, method, args, target, targetClass));
            }
        }
        return invoker.invoke();
    }

    private Class<?> getTargetClass(Object target) {
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass((Object)target);
        if (targetClass == null && target != null) {
            targetClass = target.getClass();
        }
        return targetClass;
    }

    private Object execute(Invoker invoker, CacheOperationContexts contexts) {
        this.processCacheEvicts(contexts.get(CacheEvictOperation.class), true, ExpressionEvaluator.NO_RESULT);
        ArrayList<CachePutRequest> cachePutRequests = new ArrayList<CachePutRequest>();
        this.collectPutRequests(contexts.get(CacheableOperation.class), ExpressionEvaluator.NO_RESULT, cachePutRequests, true);
        Cache.ValueWrapper result = null;
        if (cachePutRequests.isEmpty() && contexts.get(CachePutOperation.class).isEmpty()) {
            result = this.findCachedResult(contexts.get(CacheableOperation.class));
        }
        if (result == null) {
            result = new SimpleValueWrapper(invoker.invoke());
        }
        this.collectPutRequests(contexts.get(CachePutOperation.class), result.get(), cachePutRequests, false);
        for (CachePutRequest cachePutRequest : cachePutRequests) {
            cachePutRequest.apply(result.get());
        }
        this.processCacheEvicts(contexts.get(CacheEvictOperation.class), false, result.get());
        return result.get();
    }

    private void processCacheEvicts(Collection<CacheOperationContext> contexts, boolean beforeInvocation, Object result) {
        for (CacheOperationContext context : contexts) {
            CacheEvictOperation operation = (CacheEvictOperation)context.operation;
            if (beforeInvocation != operation.isBeforeInvocation() || !this.isConditionPassing(context, result)) continue;
            this.performCacheEvict(context, operation, result);
        }
    }

    private void performCacheEvict(CacheOperationContext context, CacheEvictOperation operation, Object result) {
        Object key = null;
        for (Cache cache : context.getCaches()) {
            if (operation.isCacheWide()) {
                this.logInvalidating(context, operation, null);
                cache.clear();
                continue;
            }
            if (key == null) {
                key = context.generateKey(result);
            }
            this.logInvalidating(context, operation, key);
            cache.evict(key);
        }
    }

    private void logInvalidating(CacheOperationContext context, CacheEvictOperation operation, Object key) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invalidating " + (key == null ? "entire cache" : "cache key " + key) + " for operation " + operation + " on method " + context.method));
        }
    }

    private void collectPutRequests(Collection<CacheOperationContext> contexts, Object result, Collection<CachePutRequest> putRequests, boolean whenNotInCache) {
        for (CacheOperationContext context : contexts) {
            if (!this.isConditionPassing(context, result)) continue;
            Object key = this.generateKey(context, result);
            if (whenNotInCache && this.findInCaches(context, key) != null) continue;
            putRequests.add(new CachePutRequest(context, key));
        }
    }

    private Cache.ValueWrapper findCachedResult(Collection<CacheOperationContext> contexts) {
        Cache.ValueWrapper result = null;
        for (CacheOperationContext context : contexts) {
            if (!this.isConditionPassing(context, ExpressionEvaluator.NO_RESULT) || result != null) continue;
            result = this.findInCaches(context, this.generateKey(context, ExpressionEvaluator.NO_RESULT));
        }
        return result;
    }

    private Cache.ValueWrapper findInCaches(CacheOperationContext context, Object key) {
        for (Cache cache : context.getCaches()) {
            Cache.ValueWrapper wrapper = cache.get(key);
            if (wrapper == null) continue;
            return wrapper;
        }
        return null;
    }

    private boolean isConditionPassing(CacheOperationContext context, Object result) {
        boolean passing = context.isConditionPassing(result);
        if (!passing && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Cache condition failed on method " + context.method + " for operation " + context.operation));
        }
        return passing;
    }

    private Object generateKey(CacheOperationContext context, Object result) {
        Object key = context.generateKey(result);
        Assert.notNull((Object)key, (String)("Null key returned for cache operation (maybe you are using named params on classes without debug info?) " + context.operation));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Computed cache key " + key + " for operation " + context.operation));
        }
        return key;
    }

    private static class CachePutRequest {
        private final CacheOperationContext context;
        private final Object key;

        public CachePutRequest(CacheOperationContext context, Object key) {
            this.context = context;
            this.key = key;
        }

        public void apply(Object result) {
            if (this.context.canPutToCache(result)) {
                for (Cache cache : this.context.getCaches()) {
                    cache.put(this.key, result);
                }
            }
        }
    }

    protected class CacheOperationContext {
        private final CacheOperation operation;
        private final Method method;
        private final Object[] args;
        private final Object target;
        private final Class<?> targetClass;
        private final Collection<Cache> caches;

        public CacheOperationContext(CacheOperation operation, Method method, Object[] args, Object target, Class<?> targetClass) {
            this.operation = operation;
            this.method = method;
            this.args = this.extractArgs(method, args);
            this.target = target;
            this.targetClass = targetClass;
            this.caches = CacheAspectSupport.this.getCaches(operation);
        }

        private Object[] extractArgs(Method method, Object[] args) {
            if (!method.isVarArgs()) {
                return args;
            }
            Object[] varArgs = (Object[])args[args.length - 1];
            Object[] combinedArgs = new Object[args.length - 1 + varArgs.length];
            System.arraycopy(args, 0, combinedArgs, 0, args.length - 1);
            System.arraycopy(varArgs, 0, combinedArgs, args.length - 1, varArgs.length);
            return combinedArgs;
        }

        protected boolean isConditionPassing(Object result) {
            if (StringUtils.hasText((String)this.operation.getCondition())) {
                EvaluationContext evaluationContext = this.createEvaluationContext(result);
                return CacheAspectSupport.this.evaluator.condition(this.operation.getCondition(), this.method, evaluationContext);
            }
            return true;
        }

        protected boolean canPutToCache(Object value) {
            String unless = "";
            if (this.operation instanceof CacheableOperation) {
                unless = ((CacheableOperation)this.operation).getUnless();
            } else if (this.operation instanceof CachePutOperation) {
                unless = ((CachePutOperation)this.operation).getUnless();
            }
            if (StringUtils.hasText((String)unless)) {
                EvaluationContext evaluationContext = this.createEvaluationContext(value);
                return !CacheAspectSupport.this.evaluator.unless(unless, this.method, evaluationContext);
            }
            return true;
        }

        protected Object generateKey(Object result) {
            if (StringUtils.hasText((String)this.operation.getKey())) {
                EvaluationContext evaluationContext = this.createEvaluationContext(result);
                return CacheAspectSupport.this.evaluator.key(this.operation.getKey(), this.method, evaluationContext);
            }
            return CacheAspectSupport.this.keyGenerator.generate(this.target, this.method, this.args);
        }

        private EvaluationContext createEvaluationContext(Object result) {
            return CacheAspectSupport.this.evaluator.createEvaluationContext(this.caches, this.method, this.args, this.target, this.targetClass, result);
        }

        protected Collection<Cache> getCaches() {
            return this.caches;
        }
    }

    private class CacheOperationContexts {
        private final MultiValueMap<Class<? extends CacheOperation>, CacheOperationContext> contexts = new LinkedMultiValueMap();

        public CacheOperationContexts(Collection<? extends CacheOperation> operations, Method method, Object[] args, Object target, Class<?> targetClass) {
            for (CacheOperation cacheOperation : operations) {
                this.contexts.add(cacheOperation.getClass(), (Object)new CacheOperationContext(cacheOperation, method, args, target, targetClass));
            }
        }

        public Collection<CacheOperationContext> get(Class<? extends CacheOperation> operationClass) {
            List<CacheOperationContext> result = (List<CacheOperationContext>)this.contexts.get(operationClass);
            return result != null ? result : Collections.emptyList();
        }
    }

    public static interface Invoker {
        public Object invoke();
    }
}

