/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheOperation {
    private Set<String> cacheNames = Collections.emptySet();
    private String condition = "";
    private String key = "";
    private String name = "";

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void setCacheName(String cacheName) {
        Assert.hasText((String)cacheName);
        this.cacheNames = Collections.singleton(cacheName);
    }

    public void setCacheNames(String[] cacheNames) {
        Assert.notEmpty((Object[])cacheNames);
        this.cacheNames = new LinkedHashSet<String>(cacheNames.length);
        String[] stringArray = cacheNames;
        int n = cacheNames.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.cacheNames.add(string);
            ++n2;
        }
    }

    public void setCondition(String condition) {
        Assert.notNull((Object)condition);
        this.condition = condition;
    }

    public void setKey(String key) {
        Assert.notNull((Object)key);
        this.key = key;
    }

    public void setName(String name) {
        Assert.hasText((String)name);
        this.name = name;
    }

    public boolean equals(Object other) {
        return other instanceof CacheOperation && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getOperationDescription().toString();
    }

    protected StringBuilder getOperationDescription() {
        StringBuilder result = new StringBuilder();
        result.append("CacheOperation[");
        result.append(this.name);
        result.append("] caches=");
        result.append(this.cacheNames);
        result.append(" | condition='");
        result.append(this.condition);
        result.append("' | key='");
        result.append(this.key);
        result.append("'");
        return result;
    }
}

