/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationEditor;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameMatchCacheOperationSource
implements CacheOperationSource,
Serializable {
    protected static final Log logger = LogFactory.getLog(NameMatchCacheOperationSource.class);
    private Map<String, CacheOperation> nameMap = new LinkedHashMap<String, CacheOperation>();

    public void setNameMap(Map<String, CacheOperation> nameMap) {
        for (Map.Entry<String, CacheOperation> entry : nameMap.entrySet()) {
            this.addCacheMethod(entry.getKey(), entry.getValue());
        }
    }

    public void setProperties(Properties cacheOperations) {
        CacheOperationEditor tae = new CacheOperationEditor();
        Enumeration<?> propNames = cacheOperations.propertyNames();
        while (propNames.hasMoreElements()) {
            String methodName = (String)propNames.nextElement();
            String value = cacheOperations.getProperty(methodName);
            tae.setAsText(value);
            CacheOperation op = (CacheOperation)tae.getValue();
            this.addCacheMethod(methodName, op);
        }
    }

    public void addCacheMethod(String methodName, CacheOperation operation) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding method [" + methodName + "] with cache operation [" + operation + "]"));
        }
        this.nameMap.put(methodName, operation);
    }

    @Override
    public CacheOperation getCacheOperation(Method method, Class<?> targetClass) {
        String methodName = method.getName();
        CacheOperation attr = this.nameMap.get(methodName);
        if (attr == null) {
            String bestNameMatch = null;
            for (String mappedName : this.nameMap.keySet()) {
                if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
                attr = this.nameMap.get(mappedName);
                bestNameMatch = mappedName;
            }
        }
        return attr;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch((String)mappedName, (String)methodName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NameMatchCacheOperationSource)) {
            return false;
        }
        NameMatchCacheOperationSource otherTas = (NameMatchCacheOperationSource)other;
        return ObjectUtils.nullSafeEquals(this.nameMap, otherTas.nameMap);
    }

    public int hashCode() {
        return NameMatchCacheOperationSource.class.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.nameMap;
    }
}

