/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.conversation.scope;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.conversation.Conversation;
import org.springframework.conversation.ConversationManager;
import org.springframework.conversation.manager.MutableConversation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationScope
implements Scope {
    private ConversationManager conversationManager;
    public static final String CURRENT_CONVERSATION_ATTRIBUTE_NAME = "currentConversation";

    public Object get(String name, ObjectFactory<?> objectFactory) {
        Conversation conversation = this.getConversationManager().getCurrentConversation(true);
        Object attribute = conversation.getAttribute(name);
        if (attribute == null) {
            attribute = objectFactory.getObject();
            conversation.setAttribute(name, attribute);
        }
        return attribute;
    }

    public String getConversationId() {
        Conversation conversation = this.getConversationManager().getCurrentConversation(false);
        if (conversation != null) {
            return conversation.getId();
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        Conversation conversation = this.getConversationManager().getCurrentConversation(false);
        if (conversation instanceof MutableConversation) {
            ((MutableConversation)conversation).registerDestructionCallback(name, callback);
        }
    }

    public Object remove(String name) {
        Conversation conversation = this.getConversationManager().getCurrentConversation(false);
        if (conversation != null) {
            return conversation.removeAttribute(name);
        }
        return null;
    }

    public Object resolveContextualObject(String key) {
        if (CURRENT_CONVERSATION_ATTRIBUTE_NAME.equals(key)) {
            return this.getConversationManager().getCurrentConversation(true);
        }
        return null;
    }

    public void setConversationManager(ConversationManager conversationManager) {
        this.conversationManager = conversationManager;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }
}

