/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.conversation.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.config.DestructionAwareAttributeHolder;
import org.springframework.conversation.Conversation;
import org.springframework.conversation.manager.MutableConversation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConversation
implements MutableConversation,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private MutableConversation parent;
    private List<MutableConversation> children;
    private DestructionAwareAttributeHolder attributes = new DestructionAwareAttributeHolder();
    private boolean isolated;
    private int timeout;
    private final long creationTime = System.currentTimeMillis();
    private long lastAccess;
    private boolean invalidated;

    public DefaultConversation() {
        this.touch();
    }

    @Override
    public Object getAttribute(String name) {
        this.checkValidity();
        this.touch();
        Object value = this.attributes.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (this.parent != null && !this.isolated) {
            return this.parent.getAttribute(name);
        }
        return null;
    }

    @Override
    public Object setAttribute(String name, Object value) {
        this.checkValidity();
        this.touch();
        return this.attributes.setAttribute(name, value);
    }

    @Override
    public Object removeAttribute(String name) {
        this.checkValidity();
        this.touch();
        return this.attributes.removeAttribute(name);
    }

    @Override
    public void clear() {
        this.attributes.clear();
        this.touch();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Conversation getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    @Override
    public Conversation getParent() {
        return this.parent;
    }

    @Override
    public List<? extends Conversation> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    protected void setParentConversation(MutableConversation parentConversation, boolean isIsolated) {
        this.checkValidity();
        this.parent = parentConversation;
        this.isolated = isIsolated;
    }

    @Override
    public void addChildConversation(MutableConversation conversation, boolean isIsolated) {
        this.checkValidity();
        this.touch();
        if (conversation instanceof DefaultConversation) {
            ((DefaultConversation)conversation).setParentConversation(this, isIsolated);
        }
        if (this.children == null) {
            this.children = new ArrayList<MutableConversation>();
        }
        this.children.add(conversation);
    }

    @Override
    public void removeChildConversation(MutableConversation conversation) {
        this.touch();
        if (this.children != null) {
            this.children.remove(conversation);
            if (this.children.size() == 0) {
                this.children = null;
            }
        }
        ((DefaultConversation)conversation).removeParent();
    }

    protected void removeParent() {
        this.parent = null;
    }

    @Override
    public boolean isNested() {
        return this.parent != null;
    }

    public boolean isParent() {
        return this.children != null && this.children.size() > 0;
    }

    @Override
    public boolean isIsolated() {
        return this.isolated;
    }

    @Override
    public int getTimeout() {
        if (this.parent == null) {
            return this.timeout;
        }
        return this.getRoot().getTimeout();
    }

    @Override
    public void setTimeout(int timeout) {
        if (this.parent == null) {
            this.timeout = timeout;
        } else {
            this.getRoot().setTimeout(timeout);
        }
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccess;
    }

    @Override
    public void invalidate() {
        this.invalidated = true;
        this.clear();
    }

    protected void checkValidity() {
        if (this.invalidated) {
            throw new IllegalStateException("The conversation has been invalidated!");
        }
    }

    @Override
    public boolean isExpired() {
        if (this.parent != null) {
            return this.parent.isExpired();
        }
        return this.timeout != 0 && this.lastAccess + (long)(this.timeout * 1000) < System.currentTimeMillis();
    }

    @Override
    public void touch() {
        this.lastAccess = System.currentTimeMillis();
        if (this.parent != null) {
            this.parent.touch();
        }
    }

    @Override
    public void registerDestructionCallback(String name, Runnable callback) {
        this.attributes.registerDestructionCallback(name, callback);
    }
}

