/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.conversation.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.conversation.Conversation;
import org.springframework.conversation.ConversationManager;
import org.springframework.conversation.interceptor.ConversationAttribute;
import org.springframework.conversation.interceptor.ConversationAttributeSource;

public class ConversationInterceptor
implements MethodInterceptor {
    private ConversationManager conversationManager;
    private ConversationAttributeSource conversationAttributeSource;

    public void setConversationManager(ConversationManager conversationManager) {
        this.conversationManager = conversationManager;
    }

    public void setConversationAttributeSource(ConversationAttributeSource conversationAttributeSource) {
        this.conversationAttributeSource = conversationAttributeSource;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object returnValue;
        Class<?> targetClass = invocation.getThis() != null ? invocation.getThis().getClass() : null;
        ConversationAttribute conversationAttribute = this.conversationAttributeSource.getConversationAttribute(invocation.getMethod(), targetClass);
        try {
            if (conversationAttribute != null && conversationAttribute.shouldStartConversation()) {
                Conversation conversation = this.conversationManager.beginConversation(conversationAttribute.getConversationType());
                if (conversationAttribute.getTimeout() != -1) {
                    conversation.setTimeout(conversationAttribute.getTimeout());
                }
            }
            returnValue = invocation.proceed();
            if (conversationAttribute != null && conversationAttribute.shouldEndConversation()) {
                this.conversationManager.endCurrentConversation(conversationAttribute.shouldEndRoot());
            }
        }
        catch (Throwable th) {
            if (conversationAttribute != null) {
                this.conversationManager.endCurrentConversation(conversationAttribute.shouldEndRoot());
            }
            throw th;
        }
        return returnValue;
    }
}

