/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.DefaultValueWrapper;
import org.springframework.util.Assert;

public class EhCacheCache
implements Cache {
    private final Ehcache cache;

    public EhCacheCache(Ehcache ehcache) {
        Assert.notNull((Object)ehcache, (String)"non null ehcache required");
        Status status = ehcache.getStatus();
        Assert.isTrue((boolean)Status.STATUS_ALIVE.equals(status), (String)("an 'alive' ehcache is required - current cache is " + status.toString()));
        this.cache = ehcache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Ehcache getNativeCache() {
        return this.cache;
    }

    public void clear() {
        this.cache.removeAll();
    }

    public Cache.ValueWrapper get(Object key) {
        Element element = this.cache.get(key);
        return element != null ? new DefaultValueWrapper(element.getObjectValue()) : null;
    }

    public void put(Object key, Object value) {
        this.cache.put(new Element(key, value));
    }

    public void evict(Object key) {
        this.cache.remove(key);
    }
}

