/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.config;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.parsing.ProblemCollector;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.SimpleProblemCollector;
import org.springframework.context.config.FeatureSpecificationExecutor;
import org.springframework.context.config.SourceAwareSpecification;
import org.springframework.context.config.SpecificationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureSpecification
implements SourceAwareSpecification {
    private static final Object DUMMY_SOURCE = new Object();
    private static final String DUMMY_SOURCE_NAME = "dummySource";
    protected Class<? extends FeatureSpecificationExecutor> executorType;
    private Object source = DUMMY_SOURCE;
    private String sourceName = "dummySource";

    protected AbstractFeatureSpecification(Class<? extends FeatureSpecificationExecutor> executorType) {
        this.executorType = executorType;
    }

    @Override
    public final boolean validate(ProblemReporter problemReporter) {
        SimpleProblemCollector collector = new SimpleProblemCollector(this.source());
        this.doValidate((ProblemCollector)collector);
        collector.reportProblems(problemReporter);
        return !collector.hasErrors();
    }

    protected abstract void doValidate(ProblemCollector var1);

    @Override
    public AbstractFeatureSpecification source(Object source) {
        this.source = source;
        return this;
    }

    @Override
    public Object source() {
        return this.source;
    }

    @Override
    public AbstractFeatureSpecification sourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    @Override
    public void execute(SpecificationContext specificationContext) {
        FeatureSpecificationExecutor executor = (FeatureSpecificationExecutor)BeanUtils.instantiateClass(this.executorType);
        executor.execute(this, specificationContext);
    }
}

