/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.interceptor.CacheDefinition;
import org.springframework.cache.interceptor.CacheInvalidateDefinition;
import org.springframework.cache.interceptor.CacheUpdateDefinition;
import org.springframework.cache.interceptor.DefaultCacheInvalidateDefinition;
import org.springframework.cache.interceptor.DefaultCacheUpdateDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringCachingAnnotationParser
implements CacheAnnotationParser,
Serializable {
    @Override
    public CacheDefinition parseCacheAnnotation(AnnotatedElement ae) {
        Cacheable update = this.findAnnotation(ae, Cacheable.class);
        if (update != null) {
            return this.parseCacheableAnnotation(ae, update);
        }
        CacheEvict invalidate = this.findAnnotation(ae, CacheEvict.class);
        if (invalidate != null) {
            return this.parseInvalidateAnnotation(ae, invalidate);
        }
        return null;
    }

    private <T extends Annotation> T findAnnotation(AnnotatedElement ae, Class<T> annotationType) {
        T ann = ae.getAnnotation(annotationType);
        if (ann == null) {
            Annotation[] annotationArray = ae.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation metaAnn = annotationArray[n2];
                ann = metaAnn.annotationType().getAnnotation(annotationType);
                if (ann != null) break;
                ++n2;
            }
        }
        return ann;
    }

    CacheUpdateDefinition parseCacheableAnnotation(AnnotatedElement target, Cacheable ann) {
        DefaultCacheUpdateDefinition dcud = new DefaultCacheUpdateDefinition();
        dcud.setCacheNames(ann.value());
        dcud.setCondition(ann.condition());
        dcud.setKey(ann.key());
        dcud.setName(target.toString());
        return dcud;
    }

    CacheInvalidateDefinition parseInvalidateAnnotation(AnnotatedElement target, CacheEvict ann) {
        DefaultCacheInvalidateDefinition dcid = new DefaultCacheInvalidateDefinition();
        dcid.setCacheNames(ann.value());
        dcid.setCondition(ann.condition());
        dcid.setKey(ann.key());
        dcid.setCacheWide(ann.allEntries());
        dcid.setName(target.toString());
        return dcid;
    }
}

